/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.AccountGateResult;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetOperationResultSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetOperationResultSummary> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetOperationResultSummary.getter(StackSetOperationResultSummary::account)).setter(StackSetOperationResultSummary.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetOperationResultSummary.getter(StackSetOperationResultSummary::region)).setter(StackSetOperationResultSummary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetOperationResultSummary.getter(StackSetOperationResultSummary::statusAsString)).setter(StackSetOperationResultSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetOperationResultSummary.getter(StackSetOperationResultSummary::statusReason)).setter(StackSetOperationResultSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<AccountGateResult> ACCOUNT_GATE_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StackSetOperationResultSummary.getter(StackSetOperationResultSummary::accountGateResult)).setter(StackSetOperationResultSummary.setter(Builder::accountGateResult)).constructor(AccountGateResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGateResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, REGION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_GATE_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String account;
    private final String region;
    private final String status;
    private final String statusReason;
    private final AccountGateResult accountGateResult;

    private StackSetOperationResultSummary(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGateResult = builder.accountGateResult;
    }

    public String account() {
        return this.account;
    }

    public String region() {
        return this.region;
    }

    public StackSetOperationResultStatus status() {
        return StackSetOperationResultStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public AccountGateResult accountGateResult() {
        return this.accountGateResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGateResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationResultSummary)) {
            return false;
        }
        StackSetOperationResultSummary other = (StackSetOperationResultSummary)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.accountGateResult(), other.accountGateResult());
    }

    public String toString() {
        return ToString.builder((String)"StackSetOperationResultSummary").add("Account", (Object)this.account()).add("Region", (Object)this.region()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AccountGateResult", (Object)this.accountGateResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "AccountGateResult": {
                return Optional.ofNullable(clazz.cast(this.accountGateResult()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationResultSummary, T> g) {
        return obj -> g.apply((StackSetOperationResultSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private String region;
        private String status;
        private String statusReason;
        private AccountGateResult accountGateResult;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationResultSummary model) {
            this.account(model.account);
            this.region(model.region);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.accountGateResult(model.accountGateResult);
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final AccountGateResult.Builder getAccountGateResult() {
            return this.accountGateResult != null ? this.accountGateResult.toBuilder() : null;
        }

        @Override
        public final Builder accountGateResult(AccountGateResult accountGateResult) {
            this.accountGateResult = accountGateResult;
            return this;
        }

        public final void setAccountGateResult(AccountGateResult.BuilderImpl accountGateResult) {
            this.accountGateResult = accountGateResult != null ? accountGateResult.build() : null;
        }

        public StackSetOperationResultSummary build() {
            return new StackSetOperationResultSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetOperationResultSummary> {
        public Builder account(String var1);

        public Builder region(String var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationResultStatus var1);

        public Builder statusReason(String var1);

        public Builder accountGateResult(AccountGateResult var1);

        default public Builder accountGateResult(Consumer<AccountGateResult.Builder> accountGateResult) {
            return this.accountGateResult((AccountGateResult)((AccountGateResult.Builder)AccountGateResult.builder().applyMutation(accountGateResult)).build());
        }
    }
}

