/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSet> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::stackSetName)).setter(StackSet.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::stackSetId)).setter(StackSet.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::description)).setter(StackSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::statusAsString)).setter(StackSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::templateBody)).setter(StackSet.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StackSet.getter(StackSet::parameters)).setter(StackSet.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StackSet.getter(StackSet::capabilitiesAsStrings)).setter(StackSet.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StackSet.getter(StackSet::tags)).setter(StackSet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::stackSetARN)).setter(StackSet.setter(Builder::stackSetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetARN").build()}).build();
    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::administrationRoleARN)).setter(StackSet.setter(Builder::administrationRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSet.getter(StackSet::executionRoleName)).setter(StackSet.setter(Builder::executionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, STACK_SET_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TEMPLATE_BODY_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, TAGS_FIELD, STACK_SET_ARN_FIELD, ADMINISTRATION_ROLE_ARN_FIELD, EXECUTION_ROLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackSetName;
    private final String stackSetId;
    private final String description;
    private final String status;
    private final String templateBody;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<Tag> tags;
    private final String stackSetARN;
    private final String administrationRoleARN;
    private final String executionRoleName;

    private StackSet(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.stackSetId = builder.stackSetId;
        this.description = builder.description;
        this.status = builder.status;
        this.templateBody = builder.templateBody;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.stackSetARN = builder.stackSetARN;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public String stackSetId() {
        return this.stackSetId;
    }

    public String description() {
        return this.description;
    }

    public StackSetStatus status() {
        return StackSetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String stackSetARN() {
        return this.stackSetARN;
    }

    public String administrationRoleARN() {
        return this.administrationRoleARN;
    }

    public String executionRoleName() {
        return this.executionRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSet)) {
            return false;
        }
        StackSet other = (StackSet)obj;
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stackSetARN(), other.stackSetARN()) && Objects.equals(this.administrationRoleARN(), other.administrationRoleARN()) && Objects.equals(this.executionRoleName(), other.executionRoleName());
    }

    public String toString() {
        return ToString.builder((String)"StackSet").add("StackSetName", (Object)this.stackSetName()).add("StackSetId", (Object)this.stackSetId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("TemplateBody", (Object)this.templateBody()).add("Parameters", this.parameters()).add("Capabilities", this.capabilitiesAsStrings()).add("Tags", this.tags()).add("StackSetARN", (Object)this.stackSetARN()).add("AdministrationRoleARN", (Object)this.administrationRoleARN()).add("ExecutionRoleName", (Object)this.executionRoleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StackSetARN": {
                return Optional.ofNullable(clazz.cast(this.stackSetARN()));
            }
            case "AdministrationRoleARN": {
                return Optional.ofNullable(clazz.cast(this.administrationRoleARN()));
            }
            case "ExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.executionRoleName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSet, T> g) {
        return obj -> g.apply((StackSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String stackSetId;
        private String description;
        private String status;
        private String templateBody;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String stackSetARN;
        private String administrationRoleARN;
        private String executionRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSet model) {
            this.stackSetName(model.stackSetName);
            this.stackSetId(model.stackSetId);
            this.description(model.description);
            this.status(model.status);
            this.templateBody(model.templateBody);
            this.parameters(model.parameters);
            this.capabilitiesWithStrings(model.capabilities);
            this.tags(model.tags);
            this.stackSetARN(model.stackSetARN);
            this.administrationRoleARN(model.administrationRoleARN);
            this.executionRoleName(model.executionRoleName);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilitiesAsStrings() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getStackSetARN() {
            return this.stackSetARN;
        }

        @Override
        public final Builder stackSetARN(String stackSetARN) {
            this.stackSetARN = stackSetARN;
            return this;
        }

        public final void setStackSetARN(String stackSetARN) {
            this.stackSetARN = stackSetARN;
        }

        public final String getAdministrationRoleARN() {
            return this.administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        public final String getExecutionRoleName() {
            return this.executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        public StackSet build() {
            return new StackSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSet> {
        public Builder stackSetName(String var1);

        public Builder stackSetId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(StackSetStatus var1);

        public Builder templateBody(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder stackSetARN(String var1);

        public Builder administrationRoleARN(String var1);

        public Builder executionRoleName(String var1);
    }
}

