/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetSummary> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetSummary.getter(StackSetSummary::stackSetName)).setter(StackSetSummary.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetSummary.getter(StackSetSummary::stackSetId)).setter(StackSetSummary.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetSummary.getter(StackSetSummary::description)).setter(StackSetSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetSummary.getter(StackSetSummary::statusAsString)).setter(StackSetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, STACK_SET_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackSetName;
    private final String stackSetId;
    private final String description;
    private final String status;

    private StackSetSummary(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.stackSetId = builder.stackSetId;
        this.description = builder.description;
        this.status = builder.status;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public String stackSetId() {
        return this.stackSetId;
    }

    public String description() {
        return this.description;
    }

    public StackSetStatus status() {
        return StackSetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetSummary)) {
            return false;
        }
        StackSetSummary other = (StackSetSummary)obj;
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"StackSetSummary").add("StackSetName", (Object)this.stackSetName()).add("StackSetId", (Object)this.stackSetId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetSummary, T> g) {
        return obj -> g.apply((StackSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String stackSetId;
        private String description;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetSummary model) {
            this.stackSetName(model.stackSetName);
            this.stackSetId(model.stackSetId);
            this.description(model.description);
            this.status(model.status);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public StackSetSummary build() {
            return new StackSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetSummary> {
        public Builder stackSetName(String var1);

        public Builder stackSetId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(StackSetStatus var1);
    }
}

