/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;

public class ListImportsIterable
implements SdkIterable<ListImportsResponse> {
    private final CloudFormationClient client;
    private final ListImportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportsIterable(CloudFormationClient client, ListImportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public Iterator<ListImportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> imports() {
        Function<ListImportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imports() != null) {
                return response.imports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListImportsIterable resume(ListImportsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListImportsIterable(this.client, (ListImportsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListImportsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListImportsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListImportsResponseFetcher
    implements SyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportsResponse nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsIterable.this.client.listImports(ListImportsIterable.this.firstRequest);
            }
            return ListImportsIterable.this.client.listImports((ListImportsRequest)((Object)ListImportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

