/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackSetOperationResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackSetOperationResponse> {
    private static final SdkField<StackSetOperation> STACK_SET_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackSetOperation").getter(DescribeStackSetOperationResponse.getter(DescribeStackSetOperationResponse::stackSetOperation)).setter(DescribeStackSetOperationResponse.setter(Builder::stackSetOperation)).constructor(StackSetOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetOperation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_OPERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StackSetOperation", STACK_SET_OPERATION_FIELD);
        }
    });
    private final StackSetOperation stackSetOperation;

    private DescribeStackSetOperationResponse(BuilderImpl builder) {
        super(builder);
        this.stackSetOperation = builder.stackSetOperation;
    }

    public final StackSetOperation stackSetOperation() {
        return this.stackSetOperation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetOperation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetOperationResponse)) {
            return false;
        }
        DescribeStackSetOperationResponse other = (DescribeStackSetOperationResponse)((Object)obj);
        return Objects.equals(this.stackSetOperation(), other.stackSetOperation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStackSetOperationResponse").add("StackSetOperation", (Object)this.stackSetOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetOperation": {
                return Optional.ofNullable(clazz.cast(this.stackSetOperation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSetOperationResponse, T> g) {
        return obj -> g.apply((DescribeStackSetOperationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private StackSetOperation stackSetOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetOperationResponse model) {
            super(model);
            this.stackSetOperation(model.stackSetOperation);
        }

        public final StackSetOperation.Builder getStackSetOperation() {
            return this.stackSetOperation != null ? this.stackSetOperation.toBuilder() : null;
        }

        public final void setStackSetOperation(StackSetOperation.BuilderImpl stackSetOperation) {
            this.stackSetOperation = stackSetOperation != null ? stackSetOperation.build() : null;
        }

        @Override
        public final Builder stackSetOperation(StackSetOperation stackSetOperation) {
            this.stackSetOperation = stackSetOperation;
            return this;
        }

        @Override
        public DescribeStackSetOperationResponse build() {
            return new DescribeStackSetOperationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackSetOperationResponse> {
        public Builder stackSetOperation(StackSetOperation var1);

        default public Builder stackSetOperation(Consumer<StackSetOperation.Builder> stackSetOperation) {
            return this.stackSetOperation((StackSetOperation)((StackSetOperation.Builder)StackSetOperation.builder().applyMutation(stackSetOperation)).build());
        }
    }
}

