/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypeVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypeVersionSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TypeVersionSummary.getter(TypeVersionSummary::typeAsString)).setter(TypeVersionSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(TypeVersionSummary.getter(TypeVersionSummary::typeName)).setter(TypeVersionSummary.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(TypeVersionSummary.getter(TypeVersionSummary::versionId)).setter(TypeVersionSummary.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefaultVersion").getter(TypeVersionSummary.getter(TypeVersionSummary::isDefaultVersion)).setter(TypeVersionSummary.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TypeVersionSummary.getter(TypeVersionSummary::arn)).setter(TypeVersionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeCreated").getter(TypeVersionSummary.getter(TypeVersionSummary::timeCreated)).setter(TypeVersionSummary.setter(Builder::timeCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TypeVersionSummary.getter(TypeVersionSummary::description)).setter(TypeVersionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicVersionNumber").getter(TypeVersionSummary.getter(TypeVersionSummary::publicVersionNumber)).setter(TypeVersionSummary.setter(Builder::publicVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, ARN_FIELD, TIME_CREATED_FIELD, DESCRIPTION_FIELD, PUBLIC_VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("VersionId", VERSION_ID_FIELD);
            this.put("IsDefaultVersion", IS_DEFAULT_VERSION_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("TimeCreated", TIME_CREATED_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String typeName;
    private final String versionId;
    private final Boolean isDefaultVersion;
    private final String arn;
    private final Instant timeCreated;
    private final String description;
    private final String publicVersionNumber;

    private TypeVersionSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.arn = builder.arn;
        this.timeCreated = builder.timeCreated;
        this.description = builder.description;
        this.publicVersionNumber = builder.publicVersionNumber;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant timeCreated() {
        return this.timeCreated;
    }

    public final String description() {
        return this.description;
    }

    public final String publicVersionNumber() {
        return this.publicVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicVersionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeVersionSummary)) {
            return false;
        }
        TypeVersionSummary other = (TypeVersionSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.publicVersionNumber(), other.publicVersionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"TypeVersionSummary").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("VersionId", (Object)this.versionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("Arn", (Object)this.arn()).add("TimeCreated", (Object)this.timeCreated()).add("Description", (Object)this.description()).add("PublicVersionNumber", (Object)this.publicVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "IsDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "TimeCreated": {
                return Optional.ofNullable(clazz.cast(this.timeCreated()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PublicVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.publicVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TypeVersionSummary, T> g) {
        return obj -> g.apply((TypeVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String versionId;
        private Boolean isDefaultVersion;
        private String arn;
        private Instant timeCreated;
        private String description;
        private String publicVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeVersionSummary model) {
            this.type(model.type);
            this.typeName(model.typeName);
            this.versionId(model.versionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.arn(model.arn);
            this.timeCreated(model.timeCreated);
            this.description(model.description);
            this.publicVersionNumber(model.publicVersionNumber);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getTimeCreated() {
            return this.timeCreated;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublicVersionNumber() {
            return this.publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        public TypeVersionSummary build() {
            return new TypeVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypeVersionSummary> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder versionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder arn(String var1);

        public Builder timeCreated(Instant var1);

        public Builder description(String var1);

        public Builder publicVersionNumber(String var1);
    }
}

