/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary;

public class ListStackSetOperationResultsIterable
implements SdkIterable<ListStackSetOperationResultsResponse> {
    private final CloudFormationClient client;
    private final ListStackSetOperationResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackSetOperationResultsIterable(CloudFormationClient client, ListStackSetOperationResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStackSetOperationResultsResponseFetcher();
    }

    public Iterator<ListStackSetOperationResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackSetOperationResultSummary> summaries() {
        Function<ListStackSetOperationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackSetOperationResultsResponseFetcher
    implements SyncPageFetcher<ListStackSetOperationResultsResponse> {
        private ListStackSetOperationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetOperationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackSetOperationResultsResponse nextPage(ListStackSetOperationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetOperationResultsIterable.this.client.listStackSetOperationResults(ListStackSetOperationResultsIterable.this.firstRequest);
            }
            return ListStackSetOperationResultsIterable.this.client.listStackSetOperationResults((ListStackSetOperationResultsRequest)((Object)ListStackSetOperationResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

