/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.CloudFormationServiceClientConfiguration;
import software.amazon.awssdk.services.cloudformation.DefaultCloudFormationBaseClientBuilder;
import software.amazon.awssdk.services.cloudformation.DefaultCloudFormationClient;
import software.amazon.awssdk.services.cloudformation.endpoints.CloudFormationEndpointProvider;

@SdkInternalApi
final class DefaultCloudFormationClientBuilder
extends DefaultCloudFormationBaseClientBuilder<CloudFormationClientBuilder, CloudFormationClient>
implements CloudFormationClientBuilder {
    DefaultCloudFormationClientBuilder() {
    }

    @Override
    public DefaultCloudFormationClientBuilder endpointProvider(CloudFormationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudFormationClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudFormationClientBuilder.validateClientOptions(clientConfiguration);
        CloudFormationServiceClientConfiguration serviceClientConfiguration = CloudFormationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCloudFormationClient(serviceClientConfiguration, clientConfiguration);
    }
}

