/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdentityProvider {
    AWS_MARKETPLACE("AWS_Marketplace"),
    GIT_HUB("GitHub"),
    BITBUCKET("Bitbucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdentityProvider> VALUE_MAP;
    private final String value;

    private IdentityProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityProvider> knownValues() {
        EnumSet<IdentityProvider> knownValues = EnumSet.allOf(IdentityProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdentityProvider.class, IdentityProvider::toString);
    }
}

