/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionStatus;
import software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetDriftDetectionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetDriftDetectionDetails> {
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::driftStatusAsString)).setter(StackSetDriftDetectionDetails.setter(Builder::driftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftStatus").build()}).build();
    private static final SdkField<String> DRIFT_DETECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::driftDetectionStatusAsString)).setter(StackSetDriftDetectionDetails.setter(Builder::driftDetectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftDetectionStatus").build()}).build();
    private static final SdkField<Instant> LAST_DRIFT_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::lastDriftCheckTimestamp)).setter(StackSetDriftDetectionDetails.setter(Builder::lastDriftCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDriftCheckTimestamp").build()}).build();
    private static final SdkField<Integer> TOTAL_STACK_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::totalStackInstancesCount)).setter(StackSetDriftDetectionDetails.setter(Builder::totalStackInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalStackInstancesCount").build()}).build();
    private static final SdkField<Integer> DRIFTED_STACK_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::driftedStackInstancesCount)).setter(StackSetDriftDetectionDetails.setter(Builder::driftedStackInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftedStackInstancesCount").build()}).build();
    private static final SdkField<Integer> IN_SYNC_STACK_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::inSyncStackInstancesCount)).setter(StackSetDriftDetectionDetails.setter(Builder::inSyncStackInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InSyncStackInstancesCount").build()}).build();
    private static final SdkField<Integer> IN_PROGRESS_STACK_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::inProgressStackInstancesCount)).setter(StackSetDriftDetectionDetails.setter(Builder::inProgressStackInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgressStackInstancesCount").build()}).build();
    private static final SdkField<Integer> FAILED_STACK_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StackSetDriftDetectionDetails.getter(StackSetDriftDetectionDetails::failedStackInstancesCount)).setter(StackSetDriftDetectionDetails.setter(Builder::failedStackInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStackInstancesCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRIFT_STATUS_FIELD, DRIFT_DETECTION_STATUS_FIELD, LAST_DRIFT_CHECK_TIMESTAMP_FIELD, TOTAL_STACK_INSTANCES_COUNT_FIELD, DRIFTED_STACK_INSTANCES_COUNT_FIELD, IN_SYNC_STACK_INSTANCES_COUNT_FIELD, IN_PROGRESS_STACK_INSTANCES_COUNT_FIELD, FAILED_STACK_INSTANCES_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String driftStatus;
    private final String driftDetectionStatus;
    private final Instant lastDriftCheckTimestamp;
    private final Integer totalStackInstancesCount;
    private final Integer driftedStackInstancesCount;
    private final Integer inSyncStackInstancesCount;
    private final Integer inProgressStackInstancesCount;
    private final Integer failedStackInstancesCount;

    private StackSetDriftDetectionDetails(BuilderImpl builder) {
        this.driftStatus = builder.driftStatus;
        this.driftDetectionStatus = builder.driftDetectionStatus;
        this.lastDriftCheckTimestamp = builder.lastDriftCheckTimestamp;
        this.totalStackInstancesCount = builder.totalStackInstancesCount;
        this.driftedStackInstancesCount = builder.driftedStackInstancesCount;
        this.inSyncStackInstancesCount = builder.inSyncStackInstancesCount;
        this.inProgressStackInstancesCount = builder.inProgressStackInstancesCount;
        this.failedStackInstancesCount = builder.failedStackInstancesCount;
    }

    public StackSetDriftStatus driftStatus() {
        return StackSetDriftStatus.fromValue(this.driftStatus);
    }

    public String driftStatusAsString() {
        return this.driftStatus;
    }

    public StackSetDriftDetectionStatus driftDetectionStatus() {
        return StackSetDriftDetectionStatus.fromValue(this.driftDetectionStatus);
    }

    public String driftDetectionStatusAsString() {
        return this.driftDetectionStatus;
    }

    public Instant lastDriftCheckTimestamp() {
        return this.lastDriftCheckTimestamp;
    }

    public Integer totalStackInstancesCount() {
        return this.totalStackInstancesCount;
    }

    public Integer driftedStackInstancesCount() {
        return this.driftedStackInstancesCount;
    }

    public Integer inSyncStackInstancesCount() {
        return this.inSyncStackInstancesCount;
    }

    public Integer inProgressStackInstancesCount() {
        return this.inProgressStackInstancesCount;
    }

    public Integer failedStackInstancesCount() {
        return this.failedStackInstancesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftDetectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDriftCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStackInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftedStackInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inSyncStackInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgressStackInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedStackInstancesCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetDriftDetectionDetails)) {
            return false;
        }
        StackSetDriftDetectionDetails other = (StackSetDriftDetectionDetails)obj;
        return Objects.equals(this.driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(this.driftDetectionStatusAsString(), other.driftDetectionStatusAsString()) && Objects.equals(this.lastDriftCheckTimestamp(), other.lastDriftCheckTimestamp()) && Objects.equals(this.totalStackInstancesCount(), other.totalStackInstancesCount()) && Objects.equals(this.driftedStackInstancesCount(), other.driftedStackInstancesCount()) && Objects.equals(this.inSyncStackInstancesCount(), other.inSyncStackInstancesCount()) && Objects.equals(this.inProgressStackInstancesCount(), other.inProgressStackInstancesCount()) && Objects.equals(this.failedStackInstancesCount(), other.failedStackInstancesCount());
    }

    public String toString() {
        return ToString.builder((String)"StackSetDriftDetectionDetails").add("DriftStatus", (Object)this.driftStatusAsString()).add("DriftDetectionStatus", (Object)this.driftDetectionStatusAsString()).add("LastDriftCheckTimestamp", (Object)this.lastDriftCheckTimestamp()).add("TotalStackInstancesCount", (Object)this.totalStackInstancesCount()).add("DriftedStackInstancesCount", (Object)this.driftedStackInstancesCount()).add("InSyncStackInstancesCount", (Object)this.inSyncStackInstancesCount()).add("InProgressStackInstancesCount", (Object)this.inProgressStackInstancesCount()).add("FailedStackInstancesCount", (Object)this.failedStackInstancesCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DriftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatusAsString()));
            }
            case "DriftDetectionStatus": {
                return Optional.ofNullable(clazz.cast(this.driftDetectionStatusAsString()));
            }
            case "LastDriftCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastDriftCheckTimestamp()));
            }
            case "TotalStackInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.totalStackInstancesCount()));
            }
            case "DriftedStackInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.driftedStackInstancesCount()));
            }
            case "InSyncStackInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.inSyncStackInstancesCount()));
            }
            case "InProgressStackInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.inProgressStackInstancesCount()));
            }
            case "FailedStackInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.failedStackInstancesCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetDriftDetectionDetails, T> g) {
        return obj -> g.apply((StackSetDriftDetectionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String driftStatus;
        private String driftDetectionStatus;
        private Instant lastDriftCheckTimestamp;
        private Integer totalStackInstancesCount;
        private Integer driftedStackInstancesCount;
        private Integer inSyncStackInstancesCount;
        private Integer inProgressStackInstancesCount;
        private Integer failedStackInstancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetDriftDetectionDetails model) {
            this.driftStatus(model.driftStatus);
            this.driftDetectionStatus(model.driftDetectionStatus);
            this.lastDriftCheckTimestamp(model.lastDriftCheckTimestamp);
            this.totalStackInstancesCount(model.totalStackInstancesCount);
            this.driftedStackInstancesCount(model.driftedStackInstancesCount);
            this.inSyncStackInstancesCount(model.inSyncStackInstancesCount);
            this.inProgressStackInstancesCount(model.inProgressStackInstancesCount);
            this.failedStackInstancesCount(model.failedStackInstancesCount);
        }

        public final String getDriftStatus() {
            return this.driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(StackSetDriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        public final String getDriftDetectionStatus() {
            return this.driftDetectionStatus;
        }

        @Override
        public final Builder driftDetectionStatus(String driftDetectionStatus) {
            this.driftDetectionStatus = driftDetectionStatus;
            return this;
        }

        @Override
        public final Builder driftDetectionStatus(StackSetDriftDetectionStatus driftDetectionStatus) {
            this.driftDetectionStatus(driftDetectionStatus == null ? null : driftDetectionStatus.toString());
            return this;
        }

        public final void setDriftDetectionStatus(String driftDetectionStatus) {
            this.driftDetectionStatus = driftDetectionStatus;
        }

        public final Instant getLastDriftCheckTimestamp() {
            return this.lastDriftCheckTimestamp;
        }

        @Override
        public final Builder lastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
            return this;
        }

        public final void setLastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
        }

        public final Integer getTotalStackInstancesCount() {
            return this.totalStackInstancesCount;
        }

        @Override
        public final Builder totalStackInstancesCount(Integer totalStackInstancesCount) {
            this.totalStackInstancesCount = totalStackInstancesCount;
            return this;
        }

        public final void setTotalStackInstancesCount(Integer totalStackInstancesCount) {
            this.totalStackInstancesCount = totalStackInstancesCount;
        }

        public final Integer getDriftedStackInstancesCount() {
            return this.driftedStackInstancesCount;
        }

        @Override
        public final Builder driftedStackInstancesCount(Integer driftedStackInstancesCount) {
            this.driftedStackInstancesCount = driftedStackInstancesCount;
            return this;
        }

        public final void setDriftedStackInstancesCount(Integer driftedStackInstancesCount) {
            this.driftedStackInstancesCount = driftedStackInstancesCount;
        }

        public final Integer getInSyncStackInstancesCount() {
            return this.inSyncStackInstancesCount;
        }

        @Override
        public final Builder inSyncStackInstancesCount(Integer inSyncStackInstancesCount) {
            this.inSyncStackInstancesCount = inSyncStackInstancesCount;
            return this;
        }

        public final void setInSyncStackInstancesCount(Integer inSyncStackInstancesCount) {
            this.inSyncStackInstancesCount = inSyncStackInstancesCount;
        }

        public final Integer getInProgressStackInstancesCount() {
            return this.inProgressStackInstancesCount;
        }

        @Override
        public final Builder inProgressStackInstancesCount(Integer inProgressStackInstancesCount) {
            this.inProgressStackInstancesCount = inProgressStackInstancesCount;
            return this;
        }

        public final void setInProgressStackInstancesCount(Integer inProgressStackInstancesCount) {
            this.inProgressStackInstancesCount = inProgressStackInstancesCount;
        }

        public final Integer getFailedStackInstancesCount() {
            return this.failedStackInstancesCount;
        }

        @Override
        public final Builder failedStackInstancesCount(Integer failedStackInstancesCount) {
            this.failedStackInstancesCount = failedStackInstancesCount;
            return this;
        }

        public final void setFailedStackInstancesCount(Integer failedStackInstancesCount) {
            this.failedStackInstancesCount = failedStackInstancesCount;
        }

        public StackSetDriftDetectionDetails build() {
            return new StackSetDriftDetectionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetDriftDetectionDetails> {
        public Builder driftStatus(String var1);

        public Builder driftStatus(StackSetDriftStatus var1);

        public Builder driftDetectionStatus(String var1);

        public Builder driftDetectionStatus(StackSetDriftDetectionStatus var1);

        public Builder lastDriftCheckTimestamp(Instant var1);

        public Builder totalStackInstancesCount(Integer var1);

        public Builder driftedStackInstancesCount(Integer var1);

        public Builder inSyncStackInstancesCount(Integer var1);

        public Builder inProgressStackInstancesCount(Integer var1);

        public Builder failedStackInstancesCount(Integer var1);
    }
}

