/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class DescribeStackEventsIterable
implements SdkIterable<DescribeStackEventsResponse> {
    private final CloudFormationClient client;
    private final DescribeStackEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStackEventsIterable(CloudFormationClient client, DescribeStackEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStackEventsResponseFetcher();
    }

    public Iterator<DescribeStackEventsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<StackEvent> stackEvents() {
        Function<DescribeStackEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackEvents() != null) {
                return response.stackEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeStackEventsIterable resume(DescribeStackEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStackEventsIterable(this.client, (DescribeStackEventsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeStackEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeStackEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeStackEventsResponseFetcher
    implements SyncPageFetcher<DescribeStackEventsResponse> {
        private DescribeStackEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackEventsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeStackEventsResponse nextPage(DescribeStackEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackEventsIterable.this.client.describeStackEvents(DescribeStackEventsIterable.this.firstRequest);
            }
            return DescribeStackEventsIterable.this.client.describeStackEvents((DescribeStackEventsRequest)((Object)DescribeStackEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

