/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStackSetsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackSetsResponse> {
    private final List<StackSetSummary> summaries;
    private final String nextToken;

    private ListStackSetsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackSetSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetsResponse)) {
            return false;
        }
        ListStackSetsResponse other = (ListStackSetsResponse)((Object)obj);
        return Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStackSetsResponse").add("Summaries", this.summaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.of(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackSetSummary> summaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetsResponse model) {
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackSetSummary.Builder> getSummaries() {
            return this.summaries != null ? (Collection)this.summaries.stream().map(StackSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetSummary> summaries) {
            this.summaries = StackSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<StackSetSummary.BuilderImpl> summaries) {
            this.summaries = StackSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetsResponse build() {
            return new ListStackSetsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListStackSetsResponse> {
        public Builder summaries(Collection<StackSetSummary> var1);

        public Builder summaries(StackSetSummary ... var1);

        public Builder nextToken(String var1);
    }
}

