/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail;
import software.amazon.awssdk.services.cloudformation.transform.ResourceTargetDefinitionUnmarshaller;

public class ResourceChangeDetailUnmarshaller
implements Unmarshaller<ResourceChangeDetail, StaxUnmarshallerContext> {
    private static final ResourceChangeDetailUnmarshaller INSTANCE = new ResourceChangeDetailUnmarshaller();

    public ResourceChangeDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ResourceChangeDetail.Builder resourceChangeDetail = ResourceChangeDetail.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Target", targetDepth)) {
                    resourceChangeDetail.target(ResourceTargetDefinitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Evaluation", targetDepth)) {
                    resourceChangeDetail.evaluation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ChangeSource", targetDepth)) {
                    resourceChangeDetail.changeSource(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CausingEntity", targetDepth)) continue;
                resourceChangeDetail.causingEntity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ResourceChangeDetail)resourceChangeDetail.build();
    }

    public static ResourceChangeDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

