/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.AccountGateStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountGateResult
implements ToCopyableBuilder<Builder, AccountGateResult> {
    private final String status;
    private final String statusReason;

    private AccountGateResult(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public AccountGateStatus status() {
        return AccountGateStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountGateResult)) {
            return false;
        }
        AccountGateResult other = (AccountGateResult)obj;
        return Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountGateResult model) {
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountGateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public AccountGateResult build() {
            return new AccountGateResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountGateResult> {
        public Builder status(String var1);

        public Builder status(AccountGateStatus var1);

        public Builder statusReason(String var1);
    }
}

