/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;

public class ListStackSetOperationResultsRequestMarshaller
implements Marshaller<Request<ListStackSetOperationResultsRequest>, ListStackSetOperationResultsRequest> {
    public Request<ListStackSetOperationResultsRequest> marshall(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        if (listStackSetOperationResultsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStackSetOperationResultsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackSetOperationResults");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackSetOperationResultsRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)listStackSetOperationResultsRequest.stackSetName()));
        }
        if (listStackSetOperationResultsRequest.operationId() != null) {
            request.addParameter("OperationId", StringUtils.fromString((String)listStackSetOperationResultsRequest.operationId()));
        }
        if (listStackSetOperationResultsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStackSetOperationResultsRequest.nextToken()));
        }
        if (listStackSetOperationResultsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listStackSetOperationResultsRequest.maxResults()));
        }
        return request;
    }
}

