/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateStackSetRequestMarshaller
implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {
        List<Tag> tagsList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (createStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)createStackSetRequest.stackSetName()));
        }
        if (createStackSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createStackSetRequest.description()));
        }
        if (createStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackSetRequest.templateBody()));
        }
        if (createStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackSetRequest.templateURL()));
        }
        if ((parametersList = createStackSetRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = createStackSetRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String capabilitiesListValue : capabilitiesList) {
                    if (capabilitiesListValue != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((tagsList = createStackSetRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString((String)createStackSetRequest.clientRequestToken()));
        return request;
    }
}

