/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;

public class CreateStackInstancesRequestMarshaller
implements Marshaller<Request<CreateStackInstancesRequest>, CreateStackInstancesRequest> {
    public Request<CreateStackInstancesRequest> marshall(CreateStackInstancesRequest createStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        List<String> regionsList;
        List<String> accountsList;
        if (createStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)createStackInstancesRequest.stackSetName()));
        }
        if ((accountsList = createStackInstancesRequest.accounts()) != null) {
            if (!accountsList.isEmpty()) {
                int accountsListIndex = 1;
                for (String string : accountsList) {
                    if (string != null) {
                        request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)string));
                    }
                    ++accountsListIndex;
                }
            } else {
                request.addParameter("Accounts", "");
            }
        }
        if ((regionsList = createStackInstancesRequest.regions()) != null) {
            if (!regionsList.isEmpty()) {
                int regionsListIndex = 1;
                for (String regionsListValue : regionsList) {
                    if (regionsListValue != null) {
                        request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                    }
                    ++regionsListIndex;
                }
            } else {
                request.addParameter("Regions", "");
            }
        }
        if ((operationPreferences = createStackInstancesRequest.operationPreferences()) != null) {
            List<String> list = operationPreferences.regionOrder();
            if (list != null) {
                if (!list.isEmpty()) {
                    int regionOrderListIndex = 1;
                    for (String regionOrderListValue : list) {
                        if (regionOrderListValue != null) {
                            request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                        }
                        ++regionOrderListIndex;
                    }
                } else {
                    request.addParameter("OperationPreferences.RegionOrder", "");
                }
            }
            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.failureToleranceCount()));
            }
            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.failureTolerancePercentage()));
            }
            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.maxConcurrentCount()));
            }
            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.maxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)createStackInstancesRequest.operationId()));
        return request;
    }
}

