/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;

public class ContinueUpdateRollbackRequestMarshaller
implements Marshaller<Request<ContinueUpdateRollbackRequest>, ContinueUpdateRollbackRequest> {
    public Request<ContinueUpdateRollbackRequest> marshall(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        List<String> resourcesToSkipList;
        if (continueUpdateRollbackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)continueUpdateRollbackRequest, "CloudFormationClient");
        request.addParameter("Action", "ContinueUpdateRollback");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (continueUpdateRollbackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)continueUpdateRollbackRequest.stackName()));
        }
        if (continueUpdateRollbackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)continueUpdateRollbackRequest.roleARN()));
        }
        if ((resourcesToSkipList = continueUpdateRollbackRequest.resourcesToSkip()) != null) {
            if (!resourcesToSkipList.isEmpty()) {
                int resourcesToSkipListIndex = 1;
                for (String resourcesToSkipListValue : resourcesToSkipList) {
                    if (resourcesToSkipListValue != null) {
                        request.addParameter("ResourcesToSkip.member." + resourcesToSkipListIndex, StringUtils.fromString((String)resourcesToSkipListValue));
                    }
                    ++resourcesToSkipListIndex;
                }
            } else {
                request.addParameter("ResourcesToSkip", "");
            }
        }
        if (continueUpdateRollbackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)continueUpdateRollbackRequest.clientRequestToken()));
        }
        return request;
    }
}

