/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopStackSetOperationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopStackSetOperationRequest> {
    private final String stackSetName;
    private final String operationId;

    private StopStackSetOperationRequest(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStackSetOperationRequest)) {
            return false;
        }
        StopStackSetOperationRequest other = (StopStackSetOperationRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.operationId(), other.operationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (this.operationId() != null) {
            sb.append("OperationId: ").append(this.operationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
            case "OperationId": {
                return Optional.of(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStackSetOperationRequest model) {
            this.stackSetName(model.stackSetName);
            this.operationId(model.operationId);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public StopStackSetOperationRequest build() {
            return new StopStackSetOperationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopStackSetOperationRequest> {
        public Builder stackSetName(String var1);

        public Builder operationId(String var1);
    }
}

