/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStackSetOperationResultsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStackSetOperationResultsResponse> {
    private final List<StackSetOperationResultSummary> summaries;
    private final String nextToken;

    private ListStackSetOperationResultsResponse(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackSetOperationResultSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationResultsResponse)) {
            return false;
        }
        ListStackSetOperationResultsResponse other = (ListStackSetOperationResultsResponse)((Object)obj);
        return Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.summaries() != null) {
            sb.append("Summaries: ").append(this.summaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.of(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<StackSetOperationResultSummary> summaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationResultsResponse model) {
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackSetOperationResultSummary.Builder> getSummaries() {
            return this.summaries != null ? (Collection)this.summaries.stream().map(StackSetOperationResultSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetOperationResultSummary> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetOperationResultSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<StackSetOperationResultSummary.BuilderImpl> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListStackSetOperationResultsResponse build() {
            return new ListStackSetOperationResultsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStackSetOperationResultsResponse> {
        public Builder summaries(Collection<StackSetOperationResultSummary> var1);

        public Builder summaries(StackSetOperationResultSummary ... var1);

        public Builder nextToken(String var1);
    }
}

