/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStackSetOperationResultsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListStackSetOperationResultsRequest> {
    private final String stackSetName;
    private final String operationId;
    private final String nextToken;
    private final Integer maxResults;

    private ListStackSetOperationResultsRequest(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public String operationId() {
        return this.operationId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationResultsRequest)) {
            return false;
        }
        ListStackSetOperationResultsRequest other = (ListStackSetOperationResultsRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (this.operationId() != null) {
            sb.append("OperationId: ").append(this.operationId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
            case "OperationId": {
                return Optional.of(clazz.cast(this.operationId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String operationId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationResultsRequest model) {
            this.stackSetName(model.stackSetName);
            this.operationId(model.operationId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListStackSetOperationResultsRequest build() {
            return new ListStackSetOperationResultsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStackSetOperationResultsRequest> {
        public Builder stackSetName(String var1);

        public Builder operationId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

