/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListImportsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListImportsRequest> {
    private final String exportName;
    private final String nextToken;

    private ListImportsRequest(BuilderImpl builder) {
        this.exportName = builder.exportName;
        this.nextToken = builder.nextToken;
    }

    public String exportName() {
        return this.exportName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsRequest)) {
            return false;
        }
        ListImportsRequest other = (ListImportsRequest)((Object)obj);
        return Objects.equals(this.exportName(), other.exportName()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.exportName() != null) {
            sb.append("ExportName: ").append(this.exportName()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportName": {
                return Optional.of(clazz.cast(this.exportName()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String exportName;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsRequest model) {
            this.exportName(model.exportName);
            this.nextToken(model.nextToken);
        }

        public final String getExportName() {
            return this.exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListImportsRequest build() {
            return new ListImportsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListImportsRequest> {
        public Builder exportName(String var1);

        public Builder nextToken(String var1);
    }
}

