/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeStackSetRequest> {
    private final String stackSetName;

    private DescribeStackSetRequest(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetRequest)) {
            return false;
        }
        DescribeStackSetRequest other = (DescribeStackSetRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSetName() != null) {
            sb.append("StackSetName: ").append(this.stackSetName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.of(clazz.cast(this.stackSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetRequest model) {
            this.stackSetName(model.stackSetName);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public DescribeStackSetRequest build() {
            return new DescribeStackSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackSetRequest> {
        public Builder stackSetName(String var1);
    }
}

