/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;

public class GetStackPolicyRequestMarshaller
implements Marshaller<Request<GetStackPolicyRequest>, GetStackPolicyRequest> {
    public Request<GetStackPolicyRequest> marshall(GetStackPolicyRequest getStackPolicyRequest) {
        if (getStackPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getStackPolicyRequest, "CloudFormationClient");
        request.addParameter("Action", "GetStackPolicy");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getStackPolicyRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)getStackPolicyRequest.stackName()));
        }
        return request;
    }
}

