/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        List<String> retainResourcesList;
        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)deleteStackRequest.stackName()));
        }
        if ((retainResourcesList = deleteStackRequest.retainResources()) != null) {
            if (!retainResourcesList.isEmpty()) {
                int retainResourcesListIndex = 1;
                for (String retainResourcesListValue : retainResourcesList) {
                    if (retainResourcesListValue != null) {
                        request.addParameter("RetainResources.member." + retainResourcesListIndex, StringUtils.fromString((String)retainResourcesListValue));
                    }
                    ++retainResourcesListIndex;
                }
            } else {
                request.addParameter("RetainResources", "");
            }
        }
        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)deleteStackRequest.roleARN()));
        }
        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)deleteStackRequest.clientRequestToken()));
        }
        return request;
    }
}

