/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackEvent
implements ToCopyableBuilder<Builder, StackEvent> {
    private final String stackId;
    private final String eventId;
    private final String stackName;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant timestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String resourceProperties;
    private final String clientRequestToken;

    private StackEvent(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.eventId = builder.eventId;
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackId() {
        return this.stackId;
    }

    public String eventId() {
        return this.eventId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public String resourceStatusString() {
        return this.resourceStatus;
    }

    public String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public String resourceProperties() {
        return this.resourceProperties;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.eventId() == null ? 0 : this.eventId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.physicalResourceId() == null ? 0 : this.physicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.resourceStatusString() == null ? 0 : this.resourceStatusString().hashCode());
        hashCode = 31 * hashCode + (this.resourceStatusReason() == null ? 0 : this.resourceStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.resourceProperties() == null ? 0 : this.resourceProperties().hashCode());
        hashCode = 31 * hashCode + (this.clientRequestToken() == null ? 0 : this.clientRequestToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackEvent)) {
            return false;
        }
        StackEvent other = (StackEvent)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        if (other.physicalResourceId() != null && !other.physicalResourceId().equals(this.physicalResourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.resourceStatusString() == null ^ this.resourceStatusString() == null) {
            return false;
        }
        if (other.resourceStatusString() != null && !other.resourceStatusString().equals(this.resourceStatusString())) {
            return false;
        }
        if (other.resourceStatusReason() == null ^ this.resourceStatusReason() == null) {
            return false;
        }
        if (other.resourceStatusReason() != null && !other.resourceStatusReason().equals(this.resourceStatusReason())) {
            return false;
        }
        if (other.resourceProperties() == null ^ this.resourceProperties() == null) {
            return false;
        }
        if (other.resourceProperties() != null && !other.resourceProperties().equals(this.resourceProperties())) {
            return false;
        }
        if (other.clientRequestToken() == null ^ this.clientRequestToken() == null) {
            return false;
        }
        return other.clientRequestToken() == null || other.clientRequestToken().equals(this.clientRequestToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.physicalResourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.resourceStatusString() != null) {
            sb.append("ResourceStatus: ").append(this.resourceStatusString()).append(",");
        }
        if (this.resourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(this.resourceStatusReason()).append(",");
        }
        if (this.resourceProperties() != null) {
            sb.append("ResourceProperties: ").append(this.resourceProperties()).append(",");
        }
        if (this.clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "LogicalResourceId": {
                return Optional.of(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.of(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "ResourceStatus": {
                return Optional.of(clazz.cast(this.resourceStatusString()));
            }
            case "ResourceStatusReason": {
                return Optional.of(clazz.cast(this.resourceStatusReason()));
            }
            case "ResourceProperties": {
                return Optional.of(clazz.cast(this.resourceProperties()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String eventId;
        private String stackName;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant timestamp;
        private String resourceStatus;
        private String resourceStatusReason;
        private String resourceProperties;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StackEvent model) {
            this.stackId(model.stackId);
            this.eventId(model.eventId);
            this.stackName(model.stackName);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.timestamp(model.timestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.resourceProperties(model.resourceProperties);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public StackEvent build() {
            return new StackEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackEvent> {
        public Builder stackId(String var1);

        public Builder eventId(String var1);

        public Builder stackName(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder timestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder resourceProperties(String var1);

        public Builder clientRequestToken(String var1);
    }
}

