/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.StackStatusFilterCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStacksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListStacksRequest> {
    private final String nextToken;
    private final List<String> stackStatusFilters;

    private ListStacksRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.stackStatusFilters = builder.stackStatusFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<StackStatus> stackStatusFilters() {
        return TypeConverter.convert(this.stackStatusFilters, StackStatus::fromValue);
    }

    public List<String> stackStatusFiltersStrings() {
        return this.stackStatusFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.stackStatusFiltersStrings() == null ? 0 : this.stackStatusFiltersStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.stackStatusFiltersStrings() == null ^ this.stackStatusFiltersStrings() == null) {
            return false;
        }
        return other.stackStatusFiltersStrings() == null || other.stackStatusFiltersStrings().equals(this.stackStatusFiltersStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.stackStatusFiltersStrings() != null) {
            sb.append("StackStatusFilters: ").append(this.stackStatusFiltersStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "stackStatusFilters": {
                return Optional.of(clazz.cast(this.stackStatusFiltersStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> stackStatusFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksRequest model) {
            this.nextToken(model.nextToken);
            this.stackStatusFilters(model.stackStatusFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getStackStatusFilters() {
            return this.stackStatusFilters;
        }

        @Override
        public final Builder stackStatusFilters(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFilters(String ... stackStatusFilters) {
            this.stackStatusFilters(Arrays.asList(stackStatusFilters));
            return this;
        }

        public final void setStackStatusFilters(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
        }

        public ListStacksRequest build() {
            return new ListStacksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStacksRequest> {
        public Builder nextToken(String var1);

        public Builder stackStatusFilters(Collection<String> var1);

        public Builder stackStatusFilters(String ... var1);
    }
}

