/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ChangeType;
import software.amazon.awssdk.services.cloudformation.model.ResourceChange;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Change
implements ToCopyableBuilder<Builder, Change> {
    private final String type;
    private final ResourceChange resourceChange;

    private Change(BuilderImpl builder) {
        this.type = builder.type;
        this.resourceChange = builder.resourceChange;
    }

    public ChangeType type() {
        return ChangeType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public ResourceChange resourceChange() {
        return this.resourceChange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.resourceChange() == null ? 0 : this.resourceChange().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.resourceChange() == null ^ this.resourceChange() == null) {
            return false;
        }
        return other.resourceChange() == null || other.resourceChange().equals(this.resourceChange());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.resourceChange() != null) {
            sb.append("ResourceChange: ").append(this.resourceChange()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "ResourceChange": {
                return Optional.of(clazz.cast(this.resourceChange()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private ResourceChange resourceChange;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.type(model.type);
            this.resourceChange(model.resourceChange);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ResourceChange.Builder getResourceChange() {
            return this.resourceChange != null ? this.resourceChange.toBuilder() : null;
        }

        @Override
        public final Builder resourceChange(ResourceChange resourceChange) {
            this.resourceChange = resourceChange;
            return this;
        }

        public final void setResourceChange(ResourceChange.BuilderImpl resourceChange) {
            this.resourceChange = resourceChange != null ? resourceChange.build() : null;
        }

        public Change build() {
            return new Change(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Change> {
        public Builder type(String var1);

        public Builder type(ChangeType var1);

        public Builder resourceChange(ResourceChange var1);
    }
}

