/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackResourcesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeStackResourcesRequest> {
    private final String stackName;
    private final String logicalResourceId;
    private final String physicalResourceId;

    private DescribeStackResourcesRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.logicalResourceId() == null ? 0 : this.logicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.physicalResourceId() == null ? 0 : this.physicalResourceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesRequest)) {
            return false;
        }
        DescribeStackResourcesRequest other = (DescribeStackResourcesRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.logicalResourceId() == null ^ this.logicalResourceId() == null) {
            return false;
        }
        if (other.logicalResourceId() != null && !other.logicalResourceId().equals(this.logicalResourceId())) {
            return false;
        }
        if (other.physicalResourceId() == null ^ this.physicalResourceId() == null) {
            return false;
        }
        return other.physicalResourceId() == null || other.physicalResourceId().equals(this.physicalResourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.logicalResourceId()).append(",");
        }
        if (this.physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(this.physicalResourceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String logicalResourceId;
        private String physicalResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesRequest model) {
            this.setStackName(model.stackName);
            this.setLogicalResourceId(model.logicalResourceId);
            this.setPhysicalResourceId(model.physicalResourceId);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public DescribeStackResourcesRequest build() {
            return new DescribeStackResourcesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackResourcesRequest> {
        public Builder stackName(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);
    }
}

