/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.TemplateParameter;

public class TemplateParameterUnmarshaller
implements Unmarshaller<TemplateParameter, StaxUnmarshallerContext> {
    private static final TemplateParameterUnmarshaller INSTANCE = new TemplateParameterUnmarshaller();

    public TemplateParameter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TemplateParameter.Builder templateParameter = TemplateParameter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ParameterKey", targetDepth)) {
                    templateParameter.parameterKey(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultValue", targetDepth)) {
                    templateParameter.defaultValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoEcho", targetDepth)) {
                    templateParameter.noEcho(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                templateParameter.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TemplateParameter)templateParameter.build();
    }

    public static TemplateParameterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

