/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;

public class ListStackResourcesRequestMarshaller
implements Marshaller<Request<ListStackResourcesRequest>, ListStackResourcesRequest> {
    public Request<ListStackResourcesRequest> marshall(ListStackResourcesRequest listStackResourcesRequest) {
        if (listStackResourcesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStackResourcesRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackResources");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackResourcesRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)listStackResourcesRequest.stackName()));
        }
        if (listStackResourcesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listStackResourcesRequest.nextToken()));
        }
        return request;
    }
}

