/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;

public class ListStackInstancesRequestMarshaller
implements Marshaller<Request<ListStackInstancesRequest>, ListStackInstancesRequest> {
    public Request<ListStackInstancesRequest> marshall(ListStackInstancesRequest listStackInstancesRequest) {
        if (listStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)listStackInstancesRequest.stackSetName()));
        }
        if (listStackInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listStackInstancesRequest.nextToken()));
        }
        if (listStackInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)listStackInstancesRequest.maxResults()));
        }
        if (listStackInstancesRequest.stackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount", StringConversion.fromString((String)listStackInstancesRequest.stackInstanceAccount()));
        }
        if (listStackInstancesRequest.stackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion", StringConversion.fromString((String)listStackInstancesRequest.stackInstanceRegion()));
        }
        return request;
    }
}

