/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;

public class DescribeStackResourceRequestMarshaller
implements Marshaller<Request<DescribeStackResourceRequest>, DescribeStackResourceRequest> {
    public Request<DescribeStackResourceRequest> marshall(DescribeStackResourceRequest describeStackResourceRequest) {
        if (describeStackResourceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeStackResourceRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackResourceRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)describeStackResourceRequest.stackName()));
        }
        if (describeStackResourceRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringConversion.fromString((String)describeStackResourceRequest.logicalResourceId()));
        }
        return request;
    }
}

