/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateStackSetRequestMarshaller
implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {
    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {
        if (createStackSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)createStackSetRequest.stackSetName()));
        }
        if (createStackSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createStackSetRequest.description()));
        }
        if (createStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)createStackSetRequest.templateBody()));
        }
        if (createStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)createStackSetRequest.templateURL()));
        }
        if (createStackSetRequest.parameters().isEmpty() && !(createStackSetRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createStackSetRequest.parameters().isEmpty() && !(createStackSetRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = createStackSetRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringConversion.fromString((String)parametersListValue.resolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (createStackSetRequest.capabilitiesAsStrings().isEmpty() && !(createStackSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createStackSetRequest.capabilitiesAsStrings().isEmpty() && !(createStackSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> capabilitiesList = createStackSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringConversion.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createStackSetRequest.tags().isEmpty() && !(createStackSetRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createStackSetRequest.tags().isEmpty() && !(createStackSetRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createStackSetRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createStackSetRequest.administrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN", StringConversion.fromString((String)createStackSetRequest.administrationRoleARN()));
        }
        if (createStackSetRequest.executionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringConversion.fromString((String)createStackSetRequest.executionRoleName()));
        }
        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString((String)createStackSetRequest.clientRequestToken()));
        return request;
    }
}

