/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (createStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)createStackRequest.stackName()));
        }
        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)createStackRequest.templateBody()));
        }
        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)createStackRequest.templateURL()));
        }
        if (createStackRequest.parameters().isEmpty() && !(createStackRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!createStackRequest.parameters().isEmpty() && !(createStackRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = createStackRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringConversion.fromString((String)parametersListValue.resolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringConversion.fromBoolean((Boolean)createStackRequest.disableRollback()));
        }
        if ((rollbackConfiguration = createStackRequest.rollbackConfiguration()) != null) {
            if (rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            } else if (!rollbackConfiguration.rollbackTriggers().isEmpty() && !(rollbackConfiguration.rollbackTriggers() instanceof SdkAutoConstructList)) {
                List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue.arn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringConversion.fromString((String)rollbackTriggersListValue.arn()));
                    }
                    if (rollbackTriggersListValue.type() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringConversion.fromString((String)rollbackTriggersListValue.type()));
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringConversion.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringConversion.fromInteger((Integer)createStackRequest.timeoutInMinutes()));
        }
        if (createStackRequest.notificationARNs().isEmpty() && !(createStackRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("NotificationARNs", "");
        } else if (!createStackRequest.notificationARNs().isEmpty() && !(createStackRequest.notificationARNs() instanceof SdkAutoConstructList)) {
            List<String> notificationARNsList = createStackRequest.notificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringConversion.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (createStackRequest.capabilitiesAsStrings().isEmpty() && !(createStackRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!createStackRequest.capabilitiesAsStrings().isEmpty() && !(createStackRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> capabilitiesList = createStackRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringConversion.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createStackRequest.resourceTypes().isEmpty() && !(createStackRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceTypes", "");
        } else if (!createStackRequest.resourceTypes().isEmpty() && !(createStackRequest.resourceTypes() instanceof SdkAutoConstructList)) {
            List<String> resourceTypesList = createStackRequest.resourceTypes();
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringConversion.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)createStackRequest.roleARN()));
        }
        if (createStackRequest.onFailureAsString() != null) {
            request.addParameter("OnFailure", StringConversion.fromString((String)createStackRequest.onFailureAsString()));
        }
        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringConversion.fromString((String)createStackRequest.stackPolicyBody()));
        }
        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringConversion.fromString((String)createStackRequest.stackPolicyURL()));
        }
        if (createStackRequest.tags().isEmpty() && !(createStackRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createStackRequest.tags().isEmpty() && !(createStackRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createStackRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)createStackRequest.clientRequestToken()));
        }
        if (createStackRequest.enableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection", StringConversion.fromBoolean((Boolean)createStackRequest.enableTerminationProtection()));
        }
        return request;
    }
}

