/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;

public class DescribeChangeSetRequestMarshaller
implements Marshaller<Request<DescribeChangeSetRequest>, DescribeChangeSetRequest> {
    public Request<DescribeChangeSetRequest> marshall(DescribeChangeSetRequest describeChangeSetRequest) {
        if (describeChangeSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringConversion.fromString((String)describeChangeSetRequest.changeSetName()));
        }
        if (describeChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)describeChangeSetRequest.stackName()));
        }
        if (describeChangeSetRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeChangeSetRequest.nextToken()));
        }
        return request;
    }
}

