/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;

public class ListStacksPublisher
implements SdkPublisher<ListStacksResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStacksPublisher(CloudFormationAsyncClient client, ListStacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStacksPublisher(CloudFormationAsyncClient client, ListStacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackSummary> stackSummaries() {
        Function<ListStacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackSummaries() != null) {
                return response.stackSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStacksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListStacksPublisher resume(ListStacksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStacksPublisher(this.client, (ListStacksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStacksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListStacksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListStacksResponseFetcher
    implements AsyncPageFetcher<ListStacksResponse> {
        private ListStacksResponseFetcher() {
        }

        public boolean hasNextPage(ListStacksResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListStacksResponse> nextPage(ListStacksResponse previousPage) {
            if (previousPage == null) {
                return ListStacksPublisher.this.client.listStacks(ListStacksPublisher.this.firstRequest);
            }
            return ListStacksPublisher.this.client.listStacks((ListStacksRequest)((Object)ListStacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

