/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackResource
implements ToCopyableBuilder<Builder, StackResource> {
    private final String stackName;
    private final String stackId;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant timestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String description;

    private StackResource(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.description = builder.description;
    }

    public String stackName() {
        return this.stackName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResource)) {
            return false;
        }
        StackResource other = (StackResource)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"StackResource").add("StackName", (Object)this.stackName()).add("StackId", (Object)this.stackId()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Timestamp", (Object)this.timestamp()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "LogicalResourceId": {
                return Optional.of(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.of(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "ResourceStatus": {
                return Optional.of(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.of(clazz.cast(this.resourceStatusReason()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String stackId;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant timestamp;
        private String resourceStatus;
        private String resourceStatusReason;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResource model) {
            this.stackName(model.stackName);
            this.stackId(model.stackId);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.timestamp(model.timestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.description(model.description);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public StackResource build() {
            return new StackResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackResource> {
        public Builder stackName(String var1);

        public Builder stackId(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder timestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder description(String var1);
    }
}

