/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StageListCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private final String templateBody;
    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public List<TemplateStage> stagesAvailable() {
        return TypeConverter.convert(this.stagesAvailable, TemplateStage::fromValue);
    }

    public List<String> stagesAvailableAsStrings() {
        return this.stagesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagesAvailableAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.stagesAvailableAsStrings(), other.stagesAvailableAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("TemplateBody", (Object)this.templateBody()).add("StagesAvailable", this.stagesAvailableAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.of(clazz.cast(this.templateBody()));
            }
            case "StagesAvailable": {
                return Optional.of(clazz.cast(this.stagesAvailableAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String templateBody;
        private List<String> stagesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.templateBody(model.templateBody);
            this.stagesAvailable(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<String> getStagesAvailable() {
            return this.stagesAvailable;
        }

        @Override
        public final Builder stagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(String ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder templateBody(String var1);

        public Builder stagesAvailable(Collection<String> var1);

        public Builder stagesAvailable(String ... var1);
    }
}

