/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListStackResourcesRequestMarshaller
implements Marshaller<Request<ListStackResourcesRequest>, ListStackResourcesRequest> {
    public Request<ListStackResourcesRequest> marshall(ListStackResourcesRequest listStackResourcesRequest) {
        if (listStackResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStackResourcesRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackResources");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackResourcesRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)listStackResourcesRequest.stackName()));
        }
        if (listStackResourcesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStackResourcesRequest.nextToken()));
        }
        return request;
    }
}

