/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListImportsRequestMarshaller
implements Marshaller<Request<ListImportsRequest>, ListImportsRequest> {
    public Request<ListImportsRequest> marshall(ListImportsRequest listImportsRequest) {
        if (listImportsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listImportsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListImports");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listImportsRequest.exportName() != null) {
            request.addParameter("ExportName", StringUtils.fromString((String)listImportsRequest.exportName()));
        }
        if (listImportsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listImportsRequest.nextToken()));
        }
        return request;
    }
}

