/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplySchemaResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ApplySchemaResponse> {
    private static final SdkField<String> APPLIED_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplySchemaResponse.getter(ApplySchemaResponse::appliedSchemaArn)).setter(ApplySchemaResponse.setter(Builder::appliedSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSchemaArn").build()}).build();
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplySchemaResponse.getter(ApplySchemaResponse::directoryArn)).setter(ApplySchemaResponse.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_SCHEMA_ARN_FIELD, DIRECTORY_ARN_FIELD));
    private final String appliedSchemaArn;
    private final String directoryArn;

    private ApplySchemaResponse(BuilderImpl builder) {
        super(builder);
        this.appliedSchemaArn = builder.appliedSchemaArn;
        this.directoryArn = builder.directoryArn;
    }

    public String appliedSchemaArn() {
        return this.appliedSchemaArn;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySchemaResponse)) {
            return false;
        }
        ApplySchemaResponse other = (ApplySchemaResponse)((Object)obj);
        return Objects.equals(this.appliedSchemaArn(), other.appliedSchemaArn()) && Objects.equals(this.directoryArn(), other.directoryArn());
    }

    public String toString() {
        return ToString.builder((String)"ApplySchemaResponse").add("AppliedSchemaArn", (Object)this.appliedSchemaArn()).add("DirectoryArn", (Object)this.directoryArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppliedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.appliedSchemaArn()));
            }
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplySchemaResponse, T> g) {
        return obj -> g.apply((ApplySchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private String appliedSchemaArn;
        private String directoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySchemaResponse model) {
            super(model);
            this.appliedSchemaArn(model.appliedSchemaArn);
            this.directoryArn(model.directoryArn);
        }

        public final String getAppliedSchemaArn() {
            return this.appliedSchemaArn;
        }

        @Override
        public final Builder appliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
            return this;
        }

        public final void setAppliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public ApplySchemaResponse build() {
            return new ApplySchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplySchemaResponse> {
        public Builder appliedSchemaArn(String var1);

        public Builder directoryArn(String var1);
    }
}

