/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTypedLinkFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateTypedLinkFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTypedLinkFacetRequest.getter(CreateTypedLinkFacetRequest::schemaArn)).setter(CreateTypedLinkFacetRequest.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<TypedLinkFacet> FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTypedLinkFacetRequest.getter(CreateTypedLinkFacetRequest::facet)).setter(CreateTypedLinkFacetRequest.setter(Builder::facet)).constructor(TypedLinkFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, FACET_FIELD));
    private final String schemaArn;
    private final TypedLinkFacet facet;

    private CreateTypedLinkFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.facet = builder.facet;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public TypedLinkFacet facet() {
        return this.facet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.facet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypedLinkFacetRequest)) {
            return false;
        }
        CreateTypedLinkFacetRequest other = (CreateTypedLinkFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.facet(), other.facet());
    }

    public String toString() {
        return ToString.builder((String)"CreateTypedLinkFacetRequest").add("SchemaArn", (Object)this.schemaArn()).add("Facet", (Object)this.facet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Facet": {
                return Optional.ofNullable(clazz.cast(this.facet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTypedLinkFacetRequest, T> g) {
        return obj -> g.apply((CreateTypedLinkFacetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private TypedLinkFacet facet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypedLinkFacetRequest model) {
            super(model);
            this.schemaArn(model.schemaArn);
            this.facet(model.facet);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final TypedLinkFacet.Builder getFacet() {
            return this.facet != null ? this.facet.toBuilder() : null;
        }

        @Override
        public final Builder facet(TypedLinkFacet facet) {
            this.facet = facet;
            return this;
        }

        public final void setFacet(TypedLinkFacet.BuilderImpl facet) {
            this.facet = facet != null ? facet.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTypedLinkFacetRequest build() {
            return new CreateTypedLinkFacetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTypedLinkFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder facet(TypedLinkFacet var1);

        default public Builder facet(Consumer<TypedLinkFacet.Builder> facet) {
            return this.facet((TypedLinkFacet)((TypedLinkFacet.Builder)TypedLinkFacet.builder().applyMutation(facet)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

