/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetObjectAttributesRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<GetObjectAttributesRequest.Builder, GetObjectAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(GetObjectAttributesRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(GetObjectAttributesRequest::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsistencyLevel").getter(getter(GetObjectAttributesRequest::consistencyLevelAsString))
            .setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build())
            .build();

    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaFacet").getter(getter(GetObjectAttributesRequest::schemaFacet))
            .setter(setter(Builder::schemaFacet)).constructor(SchemaFacet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(GetObjectAttributesRequest::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            OBJECT_REFERENCE_FIELD, CONSISTENCY_LEVEL_FIELD, SCHEMA_FACET_FIELD, ATTRIBUTE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryArn;

    private final ObjectReference objectReference;

    private final String consistencyLevel;

    private final SchemaFacet schemaFacet;

    private final List<String> attributeNames;

    private GetObjectAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.consistencyLevel = builder.consistencyLevel;
        this.schemaFacet = builder.schemaFacet;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Reference that identifies the object whose attributes will be retrieved.
     * </p>
     * 
     * @return Reference that identifies the object whose attributes will be retrieved.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * <p>
     * The consistency level at which to retrieve the attributes on an object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level at which to retrieve the attributes on an object.
     * @see ConsistencyLevel
     */
    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * The consistency level at which to retrieve the attributes on an object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return The consistency level at which to retrieve the attributes on an object.
     * @see ConsistencyLevel
     */
    public final String consistencyLevelAsString() {
        return consistencyLevel;
    }

    /**
     * <p>
     * Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.
     * </p>
     * 
     * @return Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.
     */
    public final SchemaFacet schemaFacet() {
        return schemaFacet;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of attribute names whose values will be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return List of attribute names whose values will be retrieved.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectAttributesRequest)) {
            return false;
        }
        GetObjectAttributesRequest other = (GetObjectAttributesRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(objectReference(), other.objectReference())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString())
                && Objects.equals(schemaFacet(), other.schemaFacet()) && hasAttributeNames() == other.hasAttributeNames()
                && Objects.equals(attributeNames(), other.attributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetObjectAttributesRequest").add("DirectoryArn", directoryArn())
                .add("ObjectReference", objectReference()).add("ConsistencyLevel", consistencyLevelAsString())
                .add("SchemaFacet", schemaFacet()).add("AttributeNames", hasAttributeNames() ? attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        case "SchemaFacet":
            return Optional.ofNullable(clazz.cast(schemaFacet()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-data-partition", DIRECTORY_ARN_FIELD);
        map.put("ObjectReference", OBJECT_REFERENCE_FIELD);
        map.put("x-amz-consistency-level", CONSISTENCY_LEVEL_FIELD);
        map.put("SchemaFacet", SCHEMA_FACET_FIELD);
        map.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetObjectAttributesRequest, T> g) {
        return obj -> g.apply((GetObjectAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetObjectAttributesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where the object resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Reference that identifies the object whose attributes will be retrieved.
         * </p>
         * 
         * @param objectReference
         *        Reference that identifies the object whose attributes will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * Reference that identifies the object whose attributes will be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * The consistency level at which to retrieve the attributes on an object.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level at which to retrieve the attributes on an object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * The consistency level at which to retrieve the attributes on an object.
         * </p>
         * 
         * @param consistencyLevel
         *        The consistency level at which to retrieve the attributes on an object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        /**
         * <p>
         * Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.
         * </p>
         * 
         * @param schemaFacet
         *        Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacet(SchemaFacet schemaFacet);

        /**
         * <p>
         * Identifier for the facet whose attributes will be retrieved. See <a>SchemaFacet</a> for details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaFacet.Builder} avoiding the need to
         * create one manually via {@link SchemaFacet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaFacet.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaFacet(SchemaFacet)}.
         * 
         * @param schemaFacet
         *        a consumer that will call methods on {@link SchemaFacet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacet(SchemaFacet)
         */
        default Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return schemaFacet(SchemaFacet.builder().applyMutation(schemaFacet).build());
        }

        /**
         * <p>
         * List of attribute names whose values will be retrieved.
         * </p>
         * 
         * @param attributeNames
         *        List of attribute names whose values will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * List of attribute names whose values will be retrieved.
         * </p>
         * 
         * @param attributeNames
         *        List of attribute names whose values will be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference objectReference;

        private String consistencyLevel;

        private SchemaFacet schemaFacet;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectAttributesRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            objectReference(model.objectReference);
            consistencyLevel(model.consistencyLevel);
            schemaFacet(model.schemaFacet);
            attributeNames(model.attributeNames);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final String getConsistencyLevel() {
            return consistencyLevel;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return schemaFacet != null ? schemaFacet.toBuilder() : null;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetObjectAttributesRequest build() {
            return new GetObjectAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
