/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;

public class ListPolicyAttachmentsIterable
implements SdkIterable<ListPolicyAttachmentsResponse> {
    private final CloudDirectoryClient client;
    private final ListPolicyAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyAttachmentsIterable(CloudDirectoryClient client, ListPolicyAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyAttachmentsResponseFetcher();
    }

    public Iterator<ListPolicyAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPolicyAttachmentsResponseFetcher
    implements SyncPageFetcher<ListPolicyAttachmentsResponse> {
        private ListPolicyAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyAttachmentsResponse nextPage(ListPolicyAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyAttachmentsIterable.this.client.listPolicyAttachments(ListPolicyAttachmentsIterable.this.firstRequest);
            }
            return ListPolicyAttachmentsIterable.this.client.listPolicyAttachments((ListPolicyAttachmentsRequest)((Object)ListPolicyAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

