/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;

public class ListObjectChildrenPublisher
implements SdkPublisher<ListObjectChildrenResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectChildrenRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectChildrenPublisher(CloudDirectoryAsyncClient client, ListObjectChildrenRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectChildrenPublisher(CloudDirectoryAsyncClient client, ListObjectChildrenRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectChildrenResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectChildrenResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListObjectChildrenPublisher resume(ListObjectChildrenResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectChildrenPublisher(this.client, (ListObjectChildrenRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectChildrenPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListObjectChildrenResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListObjectChildrenResponseFetcher
    implements AsyncPageFetcher<ListObjectChildrenResponse> {
        private ListObjectChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectChildrenResponse> nextPage(ListObjectChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListObjectChildrenPublisher.this.client.listObjectChildren(ListObjectChildrenPublisher.this.firstRequest);
            }
            return ListObjectChildrenPublisher.this.client.listObjectChildren((ListObjectChildrenRequest)((Object)ListObjectChildrenPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

