/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveFacetFromObjectRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, RemoveFacetFromObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(RemoveFacetFromObjectRequest.getter(RemoveFacetFromObjectRequest::directoryArn)).setter(RemoveFacetFromObjectRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaFacet").getter(RemoveFacetFromObjectRequest.getter(RemoveFacetFromObjectRequest::schemaFacet)).setter(RemoveFacetFromObjectRequest.setter(Builder::schemaFacet)).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectReference").getter(RemoveFacetFromObjectRequest.getter(RemoveFacetFromObjectRequest::objectReference)).setter(RemoveFacetFromObjectRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, SCHEMA_FACET_FIELD, OBJECT_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-data-partition", DIRECTORY_ARN_FIELD);
            this.put("SchemaFacet", SCHEMA_FACET_FIELD);
            this.put("ObjectReference", OBJECT_REFERENCE_FIELD);
        }
    });
    private final String directoryArn;
    private final SchemaFacet schemaFacet;
    private final ObjectReference objectReference;

    private RemoveFacetFromObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectReference = builder.objectReference;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final SchemaFacet schemaFacet() {
        return this.schemaFacet;
    }

    public final ObjectReference objectReference() {
        return this.objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFacetFromObjectRequest)) {
            return false;
        }
        RemoveFacetFromObjectRequest other = (RemoveFacetFromObjectRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.schemaFacet(), other.schemaFacet()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveFacetFromObjectRequest").add("DirectoryArn", (Object)this.directoryArn()).add("SchemaFacet", (Object)this.schemaFacet()).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "SchemaFacet": {
                return Optional.ofNullable(clazz.cast(this.schemaFacet()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFacetFromObjectRequest, T> g) {
        return obj -> g.apply((RemoveFacetFromObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private SchemaFacet schemaFacet;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFacetFromObjectRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.schemaFacet(model.schemaFacet);
            this.objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return this.schemaFacet != null ? this.schemaFacet.toBuilder() : null;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveFacetFromObjectRequest build() {
            return new RemoveFacetFromObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveFacetFromObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacet(SchemaFacet var1);

        default public Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return this.schemaFacet((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation(schemaFacet)).build());
        }

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

