/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyToPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyToPath> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(PolicyToPath.getter(PolicyToPath::path)).setter(PolicyToPath.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<List<PolicyAttachment>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(PolicyToPath.getter(PolicyToPath::policies)).setter(PolicyToPath.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Path", PATH_FIELD);
            this.put("Policies", POLICIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String path;
    private final List<PolicyAttachment> policies;

    private PolicyToPath(BuilderImpl builder) {
        this.path = builder.path;
        this.policies = builder.policies;
    }

    public final String path() {
        return this.path;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<PolicyAttachment> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyToPath)) {
            return false;
        }
        PolicyToPath other = (PolicyToPath)obj;
        return Objects.equals(this.path(), other.path()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyToPath").add("Path", (Object)this.path()).add("Policies", this.hasPolicies() ? this.policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyToPath, T> g) {
        return obj -> g.apply((PolicyToPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<PolicyAttachment> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyToPath model) {
            this.path(model.path);
            this.policies(model.policies);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final List<PolicyAttachment.Builder> getPolicies() {
            List<PolicyAttachment.Builder> result = PolicyAttachmentListCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyAttachment.BuilderImpl> policies) {
            this.policies = PolicyAttachmentListCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyAttachment> policies) {
            this.policies = PolicyAttachmentListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyAttachment ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyAttachment.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (PolicyAttachment)((PolicyAttachment.Builder)PolicyAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyToPath build() {
            return new PolicyToPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyToPath> {
        public Builder path(String var1);

        public Builder policies(Collection<PolicyAttachment> var1);

        public Builder policies(PolicyAttachment ... var1);

        public Builder policies(Consumer<PolicyAttachment.Builder> ... var1);
    }
}

