/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher;

/**
 * Service client for accessing Amazon CloudDirectory asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon Cloud Directory</fullname>
 * <p>
 * Amazon Cloud Directory is a component of the AWS Directory Service that simplifies the development and management of
 * cloud-scale web, mobile, and IoT applications. This guide describes the Cloud Directory operations that you can call
 * programmatically and includes detailed information on data types and errors. For information about Cloud Directory
 * features, see <a href="https://aws.amazon.com/directoryservice/">AWS Directory Service</a> and the <a
 * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/what_is_cloud_directory.html">Amazon Cloud
 * Directory Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudDirectoryAsyncClient extends AwsClient {
    String SERVICE_NAME = "clouddirectory";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "clouddirectory";

    /**
     * <p>
     * Adds a new <a>Facet</a> to an object. An object can have more than one facet applied on it.
     * </p>
     *
     * @param addFacetToObjectRequest
     * @return A Java Future containing the result of the AddFacetToObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AddFacetToObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AddFacetToObject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFacetToObjectResponse> addFacetToObject(AddFacetToObjectRequest addFacetToObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new <a>Facet</a> to an object. An object can have more than one facet applied on it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFacetToObjectRequest.Builder} avoiding the need
     * to create one manually via {@link AddFacetToObjectRequest#builder()}
     * </p>
     *
     * @param addFacetToObjectRequest
     *        A {@link Consumer} that will call methods on {@link AddFacetToObjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddFacetToObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AddFacetToObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AddFacetToObject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFacetToObjectResponse> addFacetToObject(
            Consumer<AddFacetToObjectRequest.Builder> addFacetToObjectRequest) {
        return addFacetToObject(AddFacetToObjectRequest.builder().applyMutation(addFacetToObjectRequest).build());
    }

    /**
     * <p>
     * Copies the input published schema, at the specified version, into the <a>Directory</a> with the same name and
     * version as that of the published schema.
     * </p>
     *
     * @param applySchemaRequest
     * @return A Java Future containing the result of the ApplySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ApplySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ApplySchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ApplySchemaResponse> applySchema(ApplySchemaRequest applySchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the input published schema, at the specified version, into the <a>Directory</a> with the same name and
     * version as that of the published schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplySchemaRequest.Builder} avoiding the need to
     * create one manually via {@link ApplySchemaRequest#builder()}
     * </p>
     *
     * @param applySchemaRequest
     *        A {@link Consumer} that will call methods on {@link ApplySchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ApplySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ApplySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ApplySchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ApplySchemaResponse> applySchema(Consumer<ApplySchemaRequest.Builder> applySchemaRequest) {
        return applySchema(ApplySchemaRequest.builder().applyMutation(applySchemaRequest).build());
    }

    /**
     * <p>
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Using the path
     * </p>
     * </li>
     * <li>
     * <p>
     * Using <code>ObjectIdentifier</code>
     * </p>
     * </li>
     * </ol>
     *
     * @param attachObjectRequest
     * @return A Java Future containing the result of the AttachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachObjectResponse> attachObject(AttachObjectRequest attachObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Using the path
     * </p>
     * </li>
     * <li>
     * <p>
     * Using <code>ObjectIdentifier</code>
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachObjectRequest.Builder} avoiding the need to
     * create one manually via {@link AttachObjectRequest#builder()}
     * </p>
     *
     * @param attachObjectRequest
     *        A {@link Consumer} that will call methods on {@link AttachObjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachObjectResponse> attachObject(Consumer<AttachObjectRequest.Builder> attachObjectRequest) {
        return attachObject(AttachObjectRequest.builder().applyMutation(attachObjectRequest).build());
    }

    /**
     * <p>
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     * </p>
     *
     * @param attachPolicyRequest
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link AttachPolicyRequest#builder()}
     * </p>
     *
     * @param attachPolicyRequest
     *        A {@link Consumer} that will call methods on {@link AttachPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(Consumer<AttachPolicyRequest.Builder> attachPolicyRequest) {
        return attachPolicy(AttachPolicyRequest.builder().applyMutation(attachPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches the specified object to the specified index.
     * </p>
     *
     * @param attachToIndexRequest
     * @return A Java Future containing the result of the AttachToIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>IndexedAttributeMissingException An object has been attempted to be attached to an object that does
     *         not have the appropriate attribute value.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachToIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachToIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachToIndexResponse> attachToIndex(AttachToIndexRequest attachToIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified object to the specified index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachToIndexRequest.Builder} avoiding the need to
     * create one manually via {@link AttachToIndexRequest#builder()}
     * </p>
     *
     * @param attachToIndexRequest
     *        A {@link Consumer} that will call methods on {@link AttachToIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachToIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>IndexedAttributeMissingException An object has been attempted to be attached to an object that does
     *         not have the appropriate attribute value.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachToIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachToIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AttachToIndexResponse> attachToIndex(Consumer<AttachToIndexRequest.Builder> attachToIndexRequest) {
        return attachToIndex(AttachToIndexRequest.builder().applyMutation(attachToIndexRequest).build());
    }

    /**
     * <p>
     * Attaches a typed link to a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param attachTypedLinkRequest
     * @return A Java Future containing the result of the AttachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachTypedLinkResponse> attachTypedLink(AttachTypedLinkRequest attachTypedLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a typed link to a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachTypedLinkRequest.Builder} avoiding the need
     * to create one manually via {@link AttachTypedLinkRequest#builder()}
     * </p>
     *
     * @param attachTypedLinkRequest
     *        A {@link Consumer} that will call methods on {@link AttachTypedLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.AttachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/AttachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachTypedLinkResponse> attachTypedLink(
            Consumer<AttachTypedLinkRequest.Builder> attachTypedLinkRequest) {
        return attachTypedLink(AttachTypedLinkRequest.builder().applyMutation(attachTypedLinkRequest).build());
    }

    /**
     * <p>
     * Performs all the read operations in a batch.
     * </p>
     *
     * @param batchReadRequest
     * @return A Java Future containing the result of the BatchRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchRead" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchReadResponse> batchRead(BatchReadRequest batchReadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs all the read operations in a batch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchReadRequest.Builder} avoiding the need to
     * create one manually via {@link BatchReadRequest#builder()}
     * </p>
     *
     * @param batchReadRequest
     *        A {@link Consumer} that will call methods on {@link BatchReadRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchRead operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchRead
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchRead" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchReadResponse> batchRead(Consumer<BatchReadRequest.Builder> batchReadRequest) {
        return batchRead(BatchReadRequest.builder().applyMutation(batchReadRequest).build());
    }

    /**
     * <p>
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     * </p>
     *
     * @param batchWriteRequest
     * @return A Java Future containing the result of the BatchWrite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>BatchWriteException A <code>BatchWrite</code> exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchWrite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchWrite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchWriteResponse> batchWrite(BatchWriteRequest batchWriteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchWriteRequest.Builder} avoiding the need to
     * create one manually via {@link BatchWriteRequest#builder()}
     * </p>
     *
     * @param batchWriteRequest
     *        A {@link Consumer} that will call methods on {@link BatchWriteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchWrite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>BatchWriteException A <code>BatchWrite</code> exception has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.BatchWrite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchWrite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchWriteResponse> batchWrite(Consumer<BatchWriteRequest.Builder> batchWriteRequest) {
        return batchWrite(BatchWriteRequest.builder().applyMutation(batchWriteRequest).build());
    }

    /**
     * <p>
     * Creates a <a>Directory</a> by copying the published schema into the directory. A directory cannot be created
     * without a schema.
     * </p>
     * <p>
     * You can also quickly create a directory using a managed schema, called the <code>QuickStartSchema</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html">Managed Schema</a>
     * in the <i>Amazon Cloud Directory Developer Guide</i>.
     * </p>
     *
     * @param createDirectoryRequest
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryAlreadyExistsException Indicates that a <a>Directory</a> could not be created due to a
     *         naming conflict. Choose a different name and try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>Directory</a> by copying the published schema into the directory. A directory cannot be created
     * without a schema.
     * </p>
     * <p>
     * You can also quickly create a directory using a managed schema, called the <code>QuickStartSchema</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html">Managed Schema</a>
     * in the <i>Amazon Cloud Directory Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDirectoryRequest#builder()}
     * </p>
     *
     * @param createDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryAlreadyExistsException Indicates that a <a>Directory</a> could not be created due to a
     *         naming conflict. Choose a different name and try again.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDirectoryResponse> createDirectory(
            Consumer<CreateDirectoryRequest.Builder> createDirectoryRequest) {
        return createDirectory(CreateDirectoryRequest.builder().applyMutation(createDirectoryRequest).build());
    }

    /**
     * <p>
     * Creates a new <a>Facet</a> in a schema. Facet creation is allowed only in development or applied schemas.
     * </p>
     *
     * @param createFacetRequest
     * @return A Java Future containing the result of the CreateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFacetResponse> createFacet(CreateFacetRequest createFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <a>Facet</a> in a schema. Facet creation is allowed only in development or applied schemas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFacetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFacetRequest#builder()}
     * </p>
     *
     * @param createFacetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFacetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFacetResponse> createFacet(Consumer<CreateFacetRequest.Builder> createFacetRequest) {
        return createFacet(CreateFacetRequest.builder().applyMutation(createFacetRequest).build());
    }

    /**
     * <p>
     * Creates an index object. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html">Indexing and
     * search</a> for more information.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an index object. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html">Indexing and
     * search</a> for more information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates an object in a <a>Directory</a>. Additionally attaches the object to a parent, if a parent reference and
     * <code>LinkName</code> is specified. An object is simply a collection of <a>Facet</a> attributes. You can also use
     * this API call to create a policy object, if the facet from which you create the object is a policy facet.
     * </p>
     *
     * @param createObjectRequest
     * @return A Java Future containing the result of the CreateObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateObjectResponse> createObject(CreateObjectRequest createObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an object in a <a>Directory</a>. Additionally attaches the object to a parent, if a parent reference and
     * <code>LinkName</code> is specified. An object is simply a collection of <a>Facet</a> attributes. You can also use
     * this API call to create a policy object, if the facet from which you create the object is a policy facet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateObjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateObjectRequest#builder()}
     * </p>
     *
     * @param createObjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateObjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>UnsupportedIndexTypeException Indicates that the requested index type is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateObjectResponse> createObject(Consumer<CreateObjectRequest.Builder> createObjectRequest) {
        return createObject(CreateObjectRequest.builder().applyMutation(createObjectRequest).build());
    }

    /**
     * <p>
     * Creates a new schema in a development state. A schema can exist in three phases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Development:</i> This is a mutable phase of the schema. All new schemas are in the development phase. Once the
     * schema is finalized, it can be published.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Published:</i> Published schemas are immutable and have a version associated with them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Applied:</i> Applied schemas are mutable in a way that allows you to add new schema facets. You can also add
     * new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     * </p>
     * </li>
     * </ul>
     *
     * @param createSchemaRequest
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new schema in a development state. A schema can exist in three phases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Development:</i> This is a mutable phase of the schema. All new schemas are in the development phase. Once the
     * schema is finalized, it can be published.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Published:</i> Published schemas are immutable and have a version associated with them.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Applied:</i> Applied schemas are mutable in a way that allows you to add new schema facets. You can also add
     * new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on {@link CreateSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest) {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Creates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param createTypedLinkFacetRequest
     * @return A Java Future containing the result of the CreateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTypedLinkFacetResponse> createTypedLinkFacet(
            CreateTypedLinkFacetRequest createTypedLinkFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTypedLinkFacetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTypedLinkFacetRequest#builder()}
     * </p>
     *
     * @param createTypedLinkFacetRequest
     *        A {@link Consumer} that will call methods on {@link CreateTypedLinkFacetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetAlreadyExistsException A facet with the same name already exists.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.CreateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/CreateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTypedLinkFacetResponse> createTypedLinkFacet(
            Consumer<CreateTypedLinkFacetRequest.Builder> createTypedLinkFacetRequest) {
        return createTypedLinkFacet(CreateTypedLinkFacetRequest.builder().applyMutation(createTypedLinkFacetRequest).build());
    }

    /**
     * <p>
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise
     * extreme caution when deleting directories.
     * </p>
     *
     * @param deleteDirectoryRequest
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryNotDisabledException An operation can only operate on a disabled directory.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise
     * extreme caution when deleting directories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDirectoryRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryNotDisabledException An operation can only operate on a disabled directory.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryResponse> deleteDirectory(
            Consumer<DeleteDirectoryRequest.Builder> deleteDirectoryRequest) {
        return deleteDirectory(DeleteDirectoryRequest.builder().applyMutation(deleteDirectoryRequest).build());
    }

    /**
     * <p>
     * Deletes a given <a>Facet</a>. All attributes and <a>Rule</a>s that are associated with the facet will be deleted.
     * Only development schema facets are allowed deletion.
     * </p>
     *
     * @param deleteFacetRequest
     * @return A Java Future containing the result of the DeleteFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>FacetInUseException Occurs when deleting a facet that contains an attribute that is a target to an
     *         attribute reference in a different facet.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFacetResponse> deleteFacet(DeleteFacetRequest deleteFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given <a>Facet</a>. All attributes and <a>Rule</a>s that are associated with the facet will be deleted.
     * Only development schema facets are allowed deletion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFacetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFacetRequest#builder()}
     * </p>
     *
     * @param deleteFacetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFacetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>FacetInUseException Occurs when deleting a facet that contains an attribute that is a target to an
     *         attribute reference in a different facet.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFacetResponse> deleteFacet(Consumer<DeleteFacetRequest.Builder> deleteFacetRequest) {
        return deleteFacet(DeleteFacetRequest.builder().applyMutation(deleteFacetRequest).build());
    }

    /**
     * <p>
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The
     * maximum number of attributes that can be deleted during an object deletion is 30. For more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory
     * Limits</a>.
     * </p>
     *
     * @param deleteObjectRequest
     * @return A Java Future containing the result of the DeleteObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectNotDetachedException Indicates that the requested operation cannot be completed because the
     *         object has not been detached from the tree.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The
     * maximum number of attributes that can be deleted during an object deletion is 30. For more information, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Amazon Cloud Directory
     * Limits</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteObjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteObjectRequest#builder()}
     * </p>
     *
     * @param deleteObjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteObjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectNotDetachedException Indicates that the requested operation cannot be completed because the
     *         object has not been detached from the tree.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteObjectResponse> deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest) {
        return deleteObject(DeleteObjectRequest.builder().applyMutation(deleteObjectRequest).build());
    }

    /**
     * <p>
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>StillContainsLinksException The object could not be deleted because links still exist. Remove the
     *         links and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>StillContainsLinksException The object could not be deleted because links still exist. Remove the
     *         links and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest) {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Deletes a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param deleteTypedLinkFacetRequest
     * @return A Java Future containing the result of the DeleteTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTypedLinkFacetResponse> deleteTypedLinkFacet(
            DeleteTypedLinkFacetRequest deleteTypedLinkFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTypedLinkFacetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTypedLinkFacetRequest#builder()}
     * </p>
     *
     * @param deleteTypedLinkFacetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTypedLinkFacetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DeleteTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DeleteTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTypedLinkFacetResponse> deleteTypedLinkFacet(
            Consumer<DeleteTypedLinkFacetRequest.Builder> deleteTypedLinkFacetRequest) {
        return deleteTypedLinkFacet(DeleteTypedLinkFacetRequest.builder().applyMutation(deleteTypedLinkFacetRequest).build());
    }

    /**
     * <p>
     * Detaches the specified object from the specified index.
     * </p>
     *
     * @param detachFromIndexRequest
     * @return A Java Future containing the result of the DetachFromIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectAlreadyDetachedException Indicates that the object is not attached to the index.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachFromIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachFromIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachFromIndexResponse> detachFromIndex(DetachFromIndexRequest detachFromIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified object from the specified index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachFromIndexRequest.Builder} avoiding the need
     * to create one manually via {@link DetachFromIndexRequest#builder()}
     * </p>
     *
     * @param detachFromIndexRequest
     *        A {@link Consumer} that will call methods on {@link DetachFromIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachFromIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ObjectAlreadyDetachedException Indicates that the object is not attached to the index.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachFromIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachFromIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachFromIndexResponse> detachFromIndex(
            Consumer<DetachFromIndexRequest.Builder> detachFromIndexRequest) {
        return detachFromIndex(DetachFromIndexRequest.builder().applyMutation(detachFromIndexRequest).build());
    }

    /**
     * <p>
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by
     * the link name.
     * </p>
     *
     * @param detachObjectRequest
     * @return A Java Future containing the result of the DetachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachObjectResponse> detachObject(DetachObjectRequest detachObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by
     * the link name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachObjectRequest.Builder} avoiding the need to
     * create one manually via {@link DetachObjectRequest#builder()}
     * </p>
     *
     * @param detachObjectRequest
     *        A {@link Consumer} that will call methods on {@link DetachObjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachObject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachObjectResponse> detachObject(Consumer<DetachObjectRequest.Builder> detachObjectRequest) {
        return detachObject(DetachObjectRequest.builder().applyMutation(detachObjectRequest).build());
    }

    /**
     * <p>
     * Detaches a policy from an object.
     * </p>
     *
     * @param detachPolicyRequest
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a policy from an object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DetachPolicyRequest#builder()}
     * </p>
     *
     * @param detachPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DetachPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(Consumer<DetachPolicyRequest.Builder> detachPolicyRequest) {
        return detachPolicy(DetachPolicyRequest.builder().applyMutation(detachPolicyRequest).build());
    }

    /**
     * <p>
     * Detaches a typed link from a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param detachTypedLinkRequest
     * @return A Java Future containing the result of the DetachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachTypedLinkResponse> detachTypedLink(DetachTypedLinkRequest detachTypedLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a typed link from a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachTypedLinkRequest.Builder} avoiding the need
     * to create one manually via {@link DetachTypedLinkRequest#builder()}
     * </p>
     *
     * @param detachTypedLinkRequest
     *        A {@link Consumer} that will call methods on {@link DetachTypedLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachTypedLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DetachTypedLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachTypedLinkResponse> detachTypedLink(
            Consumer<DetachTypedLinkRequest.Builder> detachTypedLinkRequest) {
        return detachTypedLink(DetachTypedLinkRequest.builder().applyMutation(detachTypedLinkRequest).build());
    }

    /**
     * <p>
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can
     * be disabled. Disabled directories may be reenabled.
     * </p>
     *
     * @param disableDirectoryRequest
     * @return A Java Future containing the result of the DisableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DisableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDirectoryResponse> disableDirectory(DisableDirectoryRequest disableDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can
     * be disabled. Disabled directories may be reenabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link DisableDirectoryRequest#builder()}
     * </p>
     *
     * @param disableDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link DisableDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.DisableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DisableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDirectoryResponse> disableDirectory(
            Consumer<DisableDirectoryRequest.Builder> disableDirectoryRequest) {
        return disableDirectory(DisableDirectoryRequest.builder().applyMutation(disableDirectoryRequest).build());
    }

    /**
     * <p>
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then
     * be read and written to.
     * </p>
     *
     * @param enableDirectoryRequest
     * @return A Java Future containing the result of the EnableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.EnableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/EnableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDirectoryResponse> enableDirectory(EnableDirectoryRequest enableDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then
     * be read and written to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link EnableDirectoryRequest#builder()}
     * </p>
     *
     * @param enableDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link EnableDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>DirectoryDeletedException A directory that has been deleted and to which access has been attempted.
     *         Note: The requested resource will eventually cease to exist.</li>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.EnableDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/EnableDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDirectoryResponse> enableDirectory(
            Consumer<EnableDirectoryRequest.Builder> enableDirectoryRequest) {
        return enableDirectory(EnableDirectoryRequest.builder().applyMutation(enableDirectoryRequest).build());
    }

    /**
     * <p>
     * Returns current applied schema version ARN, including the minor version in use.
     * </p>
     *
     * @param getAppliedSchemaVersionRequest
     * @return A Java Future containing the result of the GetAppliedSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetAppliedSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetAppliedSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAppliedSchemaVersionResponse> getAppliedSchemaVersion(
            GetAppliedSchemaVersionRequest getAppliedSchemaVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns current applied schema version ARN, including the minor version in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppliedSchemaVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetAppliedSchemaVersionRequest#builder()}
     * </p>
     *
     * @param getAppliedSchemaVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetAppliedSchemaVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAppliedSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetAppliedSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetAppliedSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAppliedSchemaVersionResponse> getAppliedSchemaVersion(
            Consumer<GetAppliedSchemaVersionRequest.Builder> getAppliedSchemaVersionRequest) {
        return getAppliedSchemaVersion(GetAppliedSchemaVersionRequest.builder().applyMutation(getAppliedSchemaVersionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves metadata about a directory.
     * </p>
     *
     * @param getDirectoryRequest
     * @return A Java Future containing the result of the GetDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDirectoryResponse> getDirectory(GetDirectoryRequest getDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata about a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDirectoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetDirectoryRequest#builder()}
     * </p>
     *
     * @param getDirectoryRequest
     *        A {@link Consumer} that will call methods on {@link GetDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDirectoryResponse> getDirectory(Consumer<GetDirectoryRequest.Builder> getDirectoryRequest) {
        return getDirectory(GetDirectoryRequest.builder().applyMutation(getDirectoryRequest).build());
    }

    /**
     * <p>
     * Gets details of the <a>Facet</a>, such as facet name, attributes, <a>Rule</a>s, or <code>ObjectType</code>. You
     * can call this on all kinds of schema facets -- published, development, or applied.
     * </p>
     *
     * @param getFacetRequest
     * @return A Java Future containing the result of the GetFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetFacet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFacetResponse> getFacet(GetFacetRequest getFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of the <a>Facet</a>, such as facet name, attributes, <a>Rule</a>s, or <code>ObjectType</code>. You
     * can call this on all kinds of schema facets -- published, development, or applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFacetRequest.Builder} avoiding the need to
     * create one manually via {@link GetFacetRequest#builder()}
     * </p>
     *
     * @param getFacetRequest
     *        A {@link Consumer} that will call methods on {@link GetFacetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetFacet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFacetResponse> getFacet(Consumer<GetFacetRequest.Builder> getFacetRequest) {
        return getFacet(GetFacetRequest.builder().applyMutation(getFacetRequest).build());
    }

    /**
     * <p>
     * Retrieves attributes that are associated with a typed link.
     * </p>
     *
     * @param getLinkAttributesRequest
     * @return A Java Future containing the result of the GetLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkAttributesResponse> getLinkAttributes(GetLinkAttributesRequest getLinkAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attributes that are associated with a typed link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link GetLinkAttributesRequest#builder()}
     * </p>
     *
     * @param getLinkAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetLinkAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLinkAttributesResponse> getLinkAttributes(
            Consumer<GetLinkAttributesRequest.Builder> getLinkAttributesRequest) {
        return getLinkAttributes(GetLinkAttributesRequest.builder().applyMutation(getLinkAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves attributes within a facet that are associated with an object.
     * </p>
     *
     * @param getObjectAttributesRequest
     * @return A Java Future containing the result of the GetObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetObjectAttributesResponse> getObjectAttributes(
            GetObjectAttributesRequest getObjectAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attributes within a facet that are associated with an object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetObjectAttributesRequest#builder()}
     * </p>
     *
     * @param getObjectAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetObjectAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetObjectAttributesResponse> getObjectAttributes(
            Consumer<GetObjectAttributesRequest.Builder> getObjectAttributesRequest) {
        return getObjectAttributes(GetObjectAttributesRequest.builder().applyMutation(getObjectAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata about an object.
     * </p>
     *
     * @param getObjectInformationRequest
     * @return A Java Future containing the result of the GetObjectInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetObjectInformationResponse> getObjectInformation(
            GetObjectInformationRequest getObjectInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata about an object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetObjectInformationRequest.Builder} avoiding the
     * need to create one manually via {@link GetObjectInformationRequest#builder()}
     * </p>
     *
     * @param getObjectInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetObjectInformationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetObjectInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetObjectInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetObjectInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetObjectInformationResponse> getObjectInformation(
            Consumer<GetObjectInformationRequest.Builder> getObjectInformationRequest) {
        return getObjectInformation(GetObjectInformationRequest.builder().applyMutation(getObjectInformationRequest).build());
    }

    /**
     * <p>
     * Retrieves a JSON representation of the schema. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     *
     * @param getSchemaAsJsonRequest
     * @return A Java Future containing the result of the GetSchemaAsJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetSchemaAsJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetSchemaAsJson"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaAsJsonResponse> getSchemaAsJson(GetSchemaAsJsonRequest getSchemaAsJsonRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a JSON representation of the schema. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaAsJsonRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaAsJsonRequest#builder()}
     * </p>
     *
     * @param getSchemaAsJsonRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaAsJsonRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSchemaAsJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetSchemaAsJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetSchemaAsJson"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaAsJsonResponse> getSchemaAsJson(
            Consumer<GetSchemaAsJsonRequest.Builder> getSchemaAsJsonRequest) {
        return getSchemaAsJson(GetSchemaAsJsonRequest.builder().applyMutation(getSchemaAsJsonRequest).build());
    }

    /**
     * <p>
     * Returns the identity attribute order for a specific <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param getTypedLinkFacetInformationRequest
     * @return A Java Future containing the result of the GetTypedLinkFacetInformation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetTypedLinkFacetInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetTypedLinkFacetInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTypedLinkFacetInformationResponse> getTypedLinkFacetInformation(
            GetTypedLinkFacetInformationRequest getTypedLinkFacetInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the identity attribute order for a specific <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTypedLinkFacetInformationRequest.Builder}
     * avoiding the need to create one manually via {@link GetTypedLinkFacetInformationRequest#builder()}
     * </p>
     *
     * @param getTypedLinkFacetInformationRequest
     *        A {@link Consumer} that will call methods on {@link GetTypedLinkFacetInformationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetTypedLinkFacetInformation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.GetTypedLinkFacetInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetTypedLinkFacetInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTypedLinkFacetInformationResponse> getTypedLinkFacetInformation(
            Consumer<GetTypedLinkFacetInformationRequest.Builder> getTypedLinkFacetInformationRequest) {
        return getTypedLinkFacetInformation(GetTypedLinkFacetInformationRequest.builder()
                .applyMutation(getTypedLinkFacetInformationRequest).build());
    }

    /**
     * <p>
     * Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor
     * version.
     * </p>
     *
     * @param listAppliedSchemaArnsRequest
     * @return A Java Future containing the result of the ListAppliedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAppliedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAppliedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAppliedSchemaArnsResponse> listAppliedSchemaArns(
            ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppliedSchemaArnsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppliedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listAppliedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppliedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAppliedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAppliedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAppliedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAppliedSchemaArnsResponse> listAppliedSchemaArns(
            Consumer<ListAppliedSchemaArnsRequest.Builder> listAppliedSchemaArnsRequest) {
        return listAppliedSchemaArns(ListAppliedSchemaArnsRequest.builder().applyMutation(listAppliedSchemaArnsRequest).build());
    }

    /**
     * <p>
     * Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppliedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher publisher = client.listAppliedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher publisher = client.listAppliedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppliedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppliedSchemaArnsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAppliedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAppliedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppliedSchemaArnsPublisher listAppliedSchemaArnsPaginator(
            ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) {
        return new ListAppliedSchemaArnsPublisher(this, listAppliedSchemaArnsRequest);
    }

    /**
     * <p>
     * Lists schema major versions applied to a directory. If <code>SchemaArn</code> is provided, lists the minor
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppliedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher publisher = client.listAppliedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher publisher = client.listAppliedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppliedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppliedSchemaArnsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppliedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listAppliedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppliedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAppliedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAppliedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppliedSchemaArnsPublisher listAppliedSchemaArnsPaginator(
            Consumer<ListAppliedSchemaArnsRequest.Builder> listAppliedSchemaArnsRequest) {
        return listAppliedSchemaArnsPaginator(ListAppliedSchemaArnsRequest.builder().applyMutation(listAppliedSchemaArnsRequest)
                .build());
    }

    /**
     * <p>
     * Lists indices attached to the specified object.
     * </p>
     *
     * @param listAttachedIndicesRequest
     * @return A Java Future containing the result of the ListAttachedIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAttachedIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttachedIndicesResponse> listAttachedIndices(
            ListAttachedIndicesRequest listAttachedIndicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists indices attached to the specified object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedIndicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttachedIndicesRequest#builder()}
     * </p>
     *
     * @param listAttachedIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedIndicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachedIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAttachedIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttachedIndicesResponse> listAttachedIndices(
            Consumer<ListAttachedIndicesRequest.Builder> listAttachedIndicesRequest) {
        return listAttachedIndices(ListAttachedIndicesRequest.builder().applyMutation(listAttachedIndicesRequest).build());
    }

    /**
     * <p>
     * Lists indices attached to the specified object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedIndices(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher publisher = client.listAttachedIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher publisher = client.listAttachedIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedIndices(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedIndicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAttachedIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachedIndicesPublisher listAttachedIndicesPaginator(ListAttachedIndicesRequest listAttachedIndicesRequest) {
        return new ListAttachedIndicesPublisher(this, listAttachedIndicesRequest);
    }

    /**
     * <p>
     * Lists indices attached to the specified object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedIndices(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher publisher = client.listAttachedIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher publisher = client.listAttachedIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedIndices(software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedIndicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttachedIndicesRequest#builder()}
     * </p>
     *
     * @param listAttachedIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedIndicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListAttachedIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListAttachedIndices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttachedIndicesPublisher listAttachedIndicesPaginator(
            Consumer<ListAttachedIndicesRequest.Builder> listAttachedIndicesRequest) {
        return listAttachedIndicesPaginator(ListAttachedIndicesRequest.builder().applyMutation(listAttachedIndicesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     *
     * @param listDevelopmentSchemaArnsRequest
     * @return A Java Future containing the result of the ListDevelopmentSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevelopmentSchemaArnsResponse> listDevelopmentSchemaArns(
            ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevelopmentSchemaArnsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDevelopmentSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listDevelopmentSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevelopmentSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDevelopmentSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevelopmentSchemaArnsResponse> listDevelopmentSchemaArns(
            Consumer<ListDevelopmentSchemaArnsRequest.Builder> listDevelopmentSchemaArnsRequest) {
        return listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest.builder()
                .applyMutation(listDevelopmentSchemaArnsRequest).build());
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     *
     * @return A Java Future containing the result of the ListDevelopmentSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevelopmentSchemaArnsResponse> listDevelopmentSchemaArns() {
        return listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevelopmentSchemaArnsPublisher listDevelopmentSchemaArnsPaginator() {
        return listDevelopmentSchemaArnsPaginator(ListDevelopmentSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDevelopmentSchemaArnsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevelopmentSchemaArnsPublisher listDevelopmentSchemaArnsPaginator(
            ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) {
        return new ListDevelopmentSchemaArnsPublisher(this, listDevelopmentSchemaArnsRequest);
    }

    /**
     * <p>
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher publisher = client.listDevelopmentSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevelopmentSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevelopmentSchemaArnsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDevelopmentSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listDevelopmentSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevelopmentSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDevelopmentSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDevelopmentSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevelopmentSchemaArnsPublisher listDevelopmentSchemaArnsPaginator(
            Consumer<ListDevelopmentSchemaArnsRequest.Builder> listDevelopmentSchemaArnsRequest) {
        return listDevelopmentSchemaArnsPaginator(ListDevelopmentSchemaArnsRequest.builder()
                .applyMutation(listDevelopmentSchemaArnsRequest).build());
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     *
     * @param listDirectoriesRequest
     * @return A Java Future containing the result of the ListDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDirectoriesResponse> listDirectories(ListDirectoriesRequest listDirectoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDirectoriesRequest#builder()}
     * </p>
     *
     * @param listDirectoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListDirectoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDirectoriesResponse> listDirectories(
            Consumer<ListDirectoriesRequest.Builder> listDirectoriesRequest) {
        return listDirectories(ListDirectoriesRequest.builder().applyMutation(listDirectoriesRequest).build());
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDirectoriesResponse> listDirectories() {
        return listDirectories(ListDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoriesPublisher listDirectoriesPaginator() {
        return listDirectoriesPaginator(ListDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDirectoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoriesPublisher listDirectoriesPaginator(ListDirectoriesRequest listDirectoriesRequest) {
        return new ListDirectoriesPublisher(this, listDirectoriesRequest);
    }

    /**
     * <p>
     * Lists directories created within an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher publisher = client.listDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDirectories(software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDirectoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDirectoriesRequest#builder()}
     * </p>
     *
     * @param listDirectoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListDirectoriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDirectoriesPublisher listDirectoriesPaginator(Consumer<ListDirectoriesRequest.Builder> listDirectoriesRequest) {
        return listDirectoriesPaginator(ListDirectoriesRequest.builder().applyMutation(listDirectoriesRequest).build());
    }

    /**
     * <p>
     * Retrieves attributes attached to the facet.
     * </p>
     *
     * @param listFacetAttributesRequest
     * @return A Java Future containing the result of the ListFacetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFacetAttributesResponse> listFacetAttributes(
            ListFacetAttributesRequest listFacetAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attributes attached to the facet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacetAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFacetAttributesRequest#builder()}
     * </p>
     *
     * @param listFacetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacetAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFacetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFacetAttributesResponse> listFacetAttributes(
            Consumer<ListFacetAttributesRequest.Builder> listFacetAttributesRequest) {
        return listFacetAttributes(ListFacetAttributesRequest.builder().applyMutation(listFacetAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves attributes attached to the facet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher publisher = client.listFacetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher publisher = client.listFacetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFacetAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFacetAttributesPublisher listFacetAttributesPaginator(ListFacetAttributesRequest listFacetAttributesRequest) {
        return new ListFacetAttributesPublisher(this, listFacetAttributesRequest);
    }

    /**
     * <p>
     * Retrieves attributes attached to the facet.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher publisher = client.listFacetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher publisher = client.listFacetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacetAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFacetAttributesRequest#builder()}
     * </p>
     *
     * @param listFacetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacetAttributesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFacetAttributesPublisher listFacetAttributesPaginator(
            Consumer<ListFacetAttributesRequest.Builder> listFacetAttributesRequest) {
        return listFacetAttributesPaginator(ListFacetAttributesRequest.builder().applyMutation(listFacetAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the names of facets that exist in a schema.
     * </p>
     *
     * @param listFacetNamesRequest
     * @return A Java Future containing the result of the ListFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetNames" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFacetNamesResponse> listFacetNames(ListFacetNamesRequest listFacetNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of facets that exist in a schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacetNamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFacetNamesRequest#builder()}
     * </p>
     *
     * @param listFacetNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacetNamesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetNames" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFacetNamesResponse> listFacetNames(Consumer<ListFacetNamesRequest.Builder> listFacetNamesRequest) {
        return listFacetNames(ListFacetNamesRequest.builder().applyMutation(listFacetNamesRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of facets that exist in a schema.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher publisher = client.listFacetNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher publisher = client.listFacetNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFacetNamesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetNames" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFacetNamesPublisher listFacetNamesPaginator(ListFacetNamesRequest listFacetNamesRequest) {
        return new ListFacetNamesPublisher(this, listFacetNamesRequest);
    }

    /**
     * <p>
     * Retrieves the names of facets that exist in a schema.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher publisher = client.listFacetNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher publisher = client.listFacetNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacetNamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFacetNamesRequest#builder()}
     * </p>
     *
     * @param listFacetNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacetNamesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListFacetNames" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFacetNamesPublisher listFacetNamesPaginator(Consumer<ListFacetNamesRequest.Builder> listFacetNamesRequest) {
        return listFacetNamesPaginator(ListFacetNamesRequest.builder().applyMutation(listFacetNamesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listIncomingTypedLinksRequest
     * @return A Java Future containing the result of the ListIncomingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIncomingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIncomingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIncomingTypedLinksResponse> listIncomingTypedLinks(
            ListIncomingTypedLinksRequest listIncomingTypedLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIncomingTypedLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListIncomingTypedLinksRequest#builder()}
     * </p>
     *
     * @param listIncomingTypedLinksRequest
     *        A {@link Consumer} that will call methods on {@link ListIncomingTypedLinksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIncomingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIncomingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIncomingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIncomingTypedLinksResponse> listIncomingTypedLinks(
            Consumer<ListIncomingTypedLinksRequest.Builder> listIncomingTypedLinksRequest) {
        return listIncomingTypedLinks(ListIncomingTypedLinksRequest.builder().applyMutation(listIncomingTypedLinksRequest)
                .build());
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     *
     * @param listIndexRequest
     * @return A Java Future containing the result of the ListIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndexResponse> listIndex(ListIndexRequest listIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexRequest#builder()}
     * </p>
     *
     * @param listIndexRequest
     *        A {@link Consumer} that will call methods on {@link ListIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndexResponse> listIndex(Consumer<ListIndexRequest.Builder> listIndexRequest) {
        return listIndex(ListIndexRequest.builder().applyMutation(listIndexRequest).build());
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndex(software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher publisher = client.listIndexPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher publisher = client.listIndexPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndex(software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest)} operation.</b>
     * </p>
     *
     * @param listIndexRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexPublisher listIndexPaginator(ListIndexRequest listIndexRequest) {
        return new ListIndexPublisher(this, listIndexRequest);
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndex(software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher publisher = client.listIndexPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher publisher = client.listIndexPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndex(software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexRequest#builder()}
     * </p>
     *
     * @param listIndexRequest
     *        A {@link Consumer} that will call methods on {@link ListIndexRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotIndexException Indicates that the requested operation can only operate on index objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexPublisher listIndexPaginator(Consumer<ListIndexRequest.Builder> listIndexRequest) {
        return listIndexPaginator(ListIndexRequest.builder().applyMutation(listIndexRequest).build());
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     *
     * @param listManagedSchemaArnsRequest
     * @return A Java Future containing the result of the ListManagedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedSchemaArnsResponse> listManagedSchemaArns(
            ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedSchemaArnsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listManagedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListManagedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedSchemaArnsResponse> listManagedSchemaArns(
            Consumer<ListManagedSchemaArnsRequest.Builder> listManagedSchemaArnsRequest) {
        return listManagedSchemaArns(ListManagedSchemaArnsRequest.builder().applyMutation(listManagedSchemaArnsRequest).build());
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     *
     * @return A Java Future containing the result of the ListManagedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedSchemaArnsResponse> listManagedSchemaArns() {
        return listManagedSchemaArns(ListManagedSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedSchemaArnsPublisher listManagedSchemaArnsPaginator() {
        return listManagedSchemaArnsPaginator(ListManagedSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedSchemaArnsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedSchemaArnsPublisher listManagedSchemaArnsPaginator(
            ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) {
        return new ListManagedSchemaArnsPublisher(this, listManagedSchemaArnsRequest);
    }

    /**
     * <p>
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the
     * minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher publisher = client.listManagedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedSchemaArnsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listManagedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListManagedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedSchemaArnsPublisher listManagedSchemaArnsPaginator(
            Consumer<ListManagedSchemaArnsRequest.Builder> listManagedSchemaArnsRequest) {
        return listManagedSchemaArnsPaginator(ListManagedSchemaArnsRequest.builder().applyMutation(listManagedSchemaArnsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     *
     * @param listObjectAttributesRequest
     * @return A Java Future containing the result of the ListObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectAttributesResponse> listObjectAttributes(
            ListObjectAttributesRequest listObjectAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectAttributesRequest#builder()}
     * </p>
     *
     * @param listObjectAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectAttributesResponse> listObjectAttributes(
            Consumer<ListObjectAttributesRequest.Builder> listObjectAttributesRequest) {
        return listObjectAttributes(ListObjectAttributesRequest.builder().applyMutation(listObjectAttributesRequest).build());
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectAttributes(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher publisher = client.listObjectAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher publisher = client.listObjectAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectAttributes(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectAttributesPublisher listObjectAttributesPaginator(ListObjectAttributesRequest listObjectAttributesRequest) {
        return new ListObjectAttributesPublisher(this, listObjectAttributesRequest);
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectAttributes(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher publisher = client.listObjectAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher publisher = client.listObjectAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectAttributes(software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectAttributesRequest#builder()}
     * </p>
     *
     * @param listObjectAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectAttributesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectAttributesPublisher listObjectAttributesPaginator(
            Consumer<ListObjectAttributesRequest.Builder> listObjectAttributesRequest) {
        return listObjectAttributesPaginator(ListObjectAttributesRequest.builder().applyMutation(listObjectAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     *
     * @param listObjectChildrenRequest
     * @return A Java Future containing the result of the ListObjectChildren operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectChildren"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectChildrenResponse> listObjectChildren(ListObjectChildrenRequest listObjectChildrenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectChildrenRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectChildrenRequest#builder()}
     * </p>
     *
     * @param listObjectChildrenRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectChildrenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListObjectChildren operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectChildren"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectChildrenResponse> listObjectChildren(
            Consumer<ListObjectChildrenRequest.Builder> listObjectChildrenRequest) {
        return listObjectChildren(ListObjectChildrenRequest.builder().applyMutation(listObjectChildrenRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectChildren(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher publisher = client.listObjectChildrenPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher publisher = client.listObjectChildrenPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectChildren(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectChildrenRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectChildren"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectChildrenPublisher listObjectChildrenPaginator(ListObjectChildrenRequest listObjectChildrenRequest) {
        return new ListObjectChildrenPublisher(this, listObjectChildrenRequest);
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectChildren(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher publisher = client.listObjectChildrenPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher publisher = client.listObjectChildrenPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectChildren(software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectChildrenRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectChildrenRequest#builder()}
     * </p>
     *
     * @param listObjectChildrenRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectChildrenRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>NotNodeException Occurs when any invalid operations are performed on an object that is not a node,
     *         such as calling <code>ListObjectChildren</code> for a leaf node object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectChildren"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectChildrenPublisher listObjectChildrenPaginator(
            Consumer<ListObjectChildrenRequest.Builder> listObjectChildrenRequest) {
        return listObjectChildrenPaginator(ListObjectChildrenRequest.builder().applyMutation(listObjectChildrenRequest).build());
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * <p>
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory
     * up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in
     * case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among
     * multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored
     * from the target object.
     * </p>
     *
     * @param listObjectParentPathsRequest
     * @return A Java Future containing the result of the ListObjectParentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectParentPathsResponse> listObjectParentPaths(
            ListObjectParentPathsRequest listObjectParentPathsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * <p>
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory
     * up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in
     * case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among
     * multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored
     * from the target object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectParentPathsRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectParentPathsRequest#builder()}
     * </p>
     *
     * @param listObjectParentPathsRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectParentPathsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListObjectParentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectParentPathsResponse> listObjectParentPaths(
            Consumer<ListObjectParentPathsRequest.Builder> listObjectParentPathsRequest) {
        return listObjectParentPaths(ListObjectParentPathsRequest.builder().applyMutation(listObjectParentPathsRequest).build());
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * <p>
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory
     * up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in
     * case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among
     * multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored
     * from the target object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectParentPaths(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher publisher = client.listObjectParentPathsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher publisher = client.listObjectParentPathsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectParentPaths(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectParentPathsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectParentPathsPublisher listObjectParentPathsPaginator(
            ListObjectParentPathsRequest listObjectParentPathsRequest) {
        return new ListObjectParentPathsPublisher(this, listObjectParentPathsRequest);
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * <p>
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory
     * up to the requested object. The API returns the number of paths based on user-defined <code>MaxResults</code>, in
     * case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among
     * multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored
     * from the target object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectParentPaths(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher publisher = client.listObjectParentPathsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher publisher = client.listObjectParentPathsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectParentPaths(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectParentPathsRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectParentPathsRequest#builder()}
     * </p>
     *
     * @param listObjectParentPathsRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectParentPathsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParentPaths"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectParentPathsPublisher listObjectParentPathsPaginator(
            Consumer<ListObjectParentPathsRequest.Builder> listObjectParentPathsRequest) {
        return listObjectParentPathsPaginator(ListObjectParentPathsRequest.builder().applyMutation(listObjectParentPathsRequest)
                .build());
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     *
     * @param listObjectParentsRequest
     * @return A Java Future containing the result of the ListObjectParents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>CannotListParentOfRootException Cannot list the parents of a <a>Directory</a> root.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectParentsResponse> listObjectParents(ListObjectParentsRequest listObjectParentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectParentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListObjectParentsRequest#builder()}
     * </p>
     *
     * @param listObjectParentsRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectParentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListObjectParents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>CannotListParentOfRootException Cannot list the parents of a <a>Directory</a> root.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectParentsResponse> listObjectParents(
            Consumer<ListObjectParentsRequest.Builder> listObjectParentsRequest) {
        return listObjectParents(ListObjectParentsRequest.builder().applyMutation(listObjectParentsRequest).build());
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectParents(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher publisher = client.listObjectParentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher publisher = client.listObjectParentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectParents(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectParentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>CannotListParentOfRootException Cannot list the parents of a <a>Directory</a> root.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectParentsPublisher listObjectParentsPaginator(ListObjectParentsRequest listObjectParentsRequest) {
        return new ListObjectParentsPublisher(this, listObjectParentsRequest);
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectParents(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher publisher = client.listObjectParentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher publisher = client.listObjectParentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectParents(software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectParentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListObjectParentsRequest#builder()}
     * </p>
     *
     * @param listObjectParentsRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectParentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>CannotListParentOfRootException Cannot list the parents of a <a>Directory</a> root.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectParents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectParents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectParentsPublisher listObjectParentsPaginator(
            Consumer<ListObjectParentsRequest.Builder> listObjectParentsRequest) {
        return listObjectParentsPaginator(ListObjectParentsRequest.builder().applyMutation(listObjectParentsRequest).build());
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     *
     * @param listObjectPoliciesRequest
     * @return A Java Future containing the result of the ListObjectPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectPoliciesResponse> listObjectPolicies(ListObjectPoliciesRequest listObjectPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectPoliciesRequest#builder()}
     * </p>
     *
     * @param listObjectPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListObjectPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListObjectPoliciesResponse> listObjectPolicies(
            Consumer<ListObjectPoliciesRequest.Builder> listObjectPoliciesRequest) {
        return listObjectPolicies(ListObjectPoliciesRequest.builder().applyMutation(listObjectPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectPolicies(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher publisher = client.listObjectPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher publisher = client.listObjectPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectPolicies(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listObjectPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectPoliciesPublisher listObjectPoliciesPaginator(ListObjectPoliciesRequest listObjectPoliciesRequest) {
        return new ListObjectPoliciesPublisher(this, listObjectPoliciesRequest);
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listObjectPolicies(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher publisher = client.listObjectPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher publisher = client.listObjectPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectPolicies(software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListObjectPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListObjectPoliciesRequest#builder()}
     * </p>
     *
     * @param listObjectPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListObjectPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListObjectPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListObjectPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListObjectPoliciesPublisher listObjectPoliciesPaginator(
            Consumer<ListObjectPoliciesRequest.Builder> listObjectPoliciesRequest) {
        return listObjectPoliciesPaginator(ListObjectPoliciesRequest.builder().applyMutation(listObjectPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listOutgoingTypedLinksRequest
     * @return A Java Future containing the result of the ListOutgoingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListOutgoingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListOutgoingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOutgoingTypedLinksResponse> listOutgoingTypedLinks(
            ListOutgoingTypedLinksRequest listOutgoingTypedLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutgoingTypedLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListOutgoingTypedLinksRequest#builder()}
     * </p>
     *
     * @param listOutgoingTypedLinksRequest
     *        A {@link Consumer} that will call methods on {@link ListOutgoingTypedLinksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOutgoingTypedLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListOutgoingTypedLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListOutgoingTypedLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOutgoingTypedLinksResponse> listOutgoingTypedLinks(
            Consumer<ListOutgoingTypedLinksRequest.Builder> listOutgoingTypedLinksRequest) {
        return listOutgoingTypedLinks(ListOutgoingTypedLinksRequest.builder().applyMutation(listOutgoingTypedLinksRequest)
                .build());
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     *
     * @param listPolicyAttachmentsRequest
     * @return A Java Future containing the result of the ListPolicyAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPolicyAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPolicyAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPolicyAttachmentsResponse> listPolicyAttachments(
            ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyAttachmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyAttachmentsRequest#builder()}
     * </p>
     *
     * @param listPolicyAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyAttachmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPolicyAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPolicyAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPolicyAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPolicyAttachmentsResponse> listPolicyAttachments(
            Consumer<ListPolicyAttachmentsRequest.Builder> listPolicyAttachmentsRequest) {
        return listPolicyAttachments(ListPolicyAttachmentsRequest.builder().applyMutation(listPolicyAttachmentsRequest).build());
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyAttachments(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher publisher = client.listPolicyAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher publisher = client.listPolicyAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyAttachments(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPolicyAttachmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPolicyAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPolicyAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPolicyAttachmentsPublisher listPolicyAttachmentsPaginator(
            ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        return new ListPolicyAttachmentsPublisher(this, listPolicyAttachmentsRequest);
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyAttachments(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher publisher = client.listPolicyAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher publisher = client.listPolicyAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyAttachments(software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyAttachmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyAttachmentsRequest#builder()}
     * </p>
     *
     * @param listPolicyAttachmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyAttachmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>NotPolicyException Indicates that the requested operation can only operate on policy objects.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPolicyAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPolicyAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPolicyAttachmentsPublisher listPolicyAttachmentsPaginator(
            Consumer<ListPolicyAttachmentsRequest.Builder> listPolicyAttachmentsRequest) {
        return listPolicyAttachmentsPaginator(ListPolicyAttachmentsRequest.builder().applyMutation(listPolicyAttachmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     *
     * @param listPublishedSchemaArnsRequest
     * @return A Java Future containing the result of the ListPublishedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPublishedSchemaArnsResponse> listPublishedSchemaArns(
            ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishedSchemaArnsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listPublishedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListPublishedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPublishedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPublishedSchemaArnsResponse> listPublishedSchemaArns(
            Consumer<ListPublishedSchemaArnsRequest.Builder> listPublishedSchemaArnsRequest) {
        return listPublishedSchemaArns(ListPublishedSchemaArnsRequest.builder().applyMutation(listPublishedSchemaArnsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     *
     * @return A Java Future containing the result of the ListPublishedSchemaArns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPublishedSchemaArnsResponse> listPublishedSchemaArns() {
        return listPublishedSchemaArns(ListPublishedSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishedSchemaArnsPublisher listPublishedSchemaArnsPaginator() {
        return listPublishedSchemaArnsPaginator(ListPublishedSchemaArnsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPublishedSchemaArnsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishedSchemaArnsPublisher listPublishedSchemaArnsPaginator(
            ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) {
        return new ListPublishedSchemaArnsPublisher(this, listPublishedSchemaArnsRequest);
    }

    /**
     * <p>
     * Lists the major version families of each published schema. If a major version ARN is provided as
     * <code>SchemaArn</code>, the minor version revisions in that family are listed instead.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher publisher = client.listPublishedSchemaArnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishedSchemaArns(software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishedSchemaArnsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishedSchemaArnsRequest#builder()}
     * </p>
     *
     * @param listPublishedSchemaArnsRequest
     *        A {@link Consumer} that will call methods on {@link ListPublishedSchemaArnsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListPublishedSchemaArns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishedSchemaArnsPublisher listPublishedSchemaArnsPaginator(
            Consumer<ListPublishedSchemaArnsRequest.Builder> listPublishedSchemaArnsRequest) {
        return listPublishedSchemaArnsPaginator(ListPublishedSchemaArnsRequest.builder()
                .applyMutation(listPublishedSchemaArnsRequest).build());
    }

    /**
     * <p>
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per
     * directory. All 50 tags are returned for a given directory with this API call.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per
     * directory. All 50 tags are returned for a given directory with this API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per
     * directory. All 50 tags are returned for a given directory with this API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per
     * directory. All 50 tags are returned for a given directory with this API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listTypedLinkFacetAttributesRequest
     * @return A Java Future containing the result of the ListTypedLinkFacetAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypedLinkFacetAttributesResponse> listTypedLinkFacetAttributes(
            ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypedLinkFacetAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ListTypedLinkFacetAttributesRequest#builder()}
     * </p>
     *
     * @param listTypedLinkFacetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypedLinkFacetAttributesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTypedLinkFacetAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypedLinkFacetAttributesResponse> listTypedLinkFacetAttributes(
            Consumer<ListTypedLinkFacetAttributesRequest.Builder> listTypedLinkFacetAttributesRequest) {
        return listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesRequest.builder()
                .applyMutation(listTypedLinkFacetAttributesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypedLinkFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher publisher = client.listTypedLinkFacetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher publisher = client.listTypedLinkFacetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypedLinkFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypedLinkFacetAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypedLinkFacetAttributesPublisher listTypedLinkFacetAttributesPaginator(
            ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) {
        return new ListTypedLinkFacetAttributesPublisher(this, listTypedLinkFacetAttributesRequest);
    }

    /**
     * <p>
     * Returns a paginated list of all attribute definitions for a particular <a>TypedLinkFacet</a>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypedLinkFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher publisher = client.listTypedLinkFacetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher publisher = client.listTypedLinkFacetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypedLinkFacetAttributes(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypedLinkFacetAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ListTypedLinkFacetAttributesRequest#builder()}
     * </p>
     *
     * @param listTypedLinkFacetAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypedLinkFacetAttributesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypedLinkFacetAttributesPublisher listTypedLinkFacetAttributesPaginator(
            Consumer<ListTypedLinkFacetAttributesRequest.Builder> listTypedLinkFacetAttributesRequest) {
        return listTypedLinkFacetAttributesPaginator(ListTypedLinkFacetAttributesRequest.builder()
                .applyMutation(listTypedLinkFacetAttributesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param listTypedLinkFacetNamesRequest
     * @return A Java Future containing the result of the ListTypedLinkFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypedLinkFacetNamesResponse> listTypedLinkFacetNames(
            ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypedLinkFacetNamesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTypedLinkFacetNamesRequest#builder()}
     * </p>
     *
     * @param listTypedLinkFacetNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypedLinkFacetNamesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTypedLinkFacetNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypedLinkFacetNamesResponse> listTypedLinkFacetNames(
            Consumer<ListTypedLinkFacetNamesRequest.Builder> listTypedLinkFacetNamesRequest) {
        return listTypedLinkFacetNames(ListTypedLinkFacetNamesRequest.builder().applyMutation(listTypedLinkFacetNamesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypedLinkFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher publisher = client.listTypedLinkFacetNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher publisher = client.listTypedLinkFacetNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypedLinkFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypedLinkFacetNamesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypedLinkFacetNamesPublisher listTypedLinkFacetNamesPaginator(
            ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) {
        return new ListTypedLinkFacetNamesPublisher(this, listTypedLinkFacetNamesRequest);
    }

    /**
     * <p>
     * Returns a paginated list of <code>TypedLink</code> facet names for a particular schema. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypedLinkFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher publisher = client.listTypedLinkFacetNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher publisher = client.listTypedLinkFacetNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypedLinkFacetNames(software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypedLinkFacetNamesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTypedLinkFacetNamesRequest#builder()}
     * </p>
     *
     * @param listTypedLinkFacetNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypedLinkFacetNamesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.ListTypedLinkFacetNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypedLinkFacetNamesPublisher listTypedLinkFacetNamesPaginator(
            Consumer<ListTypedLinkFacetNamesRequest.Builder> listTypedLinkFacetNamesRequest) {
        return listTypedLinkFacetNamesPaginator(ListTypedLinkFacetNamesRequest.builder()
                .applyMutation(listTypedLinkFacetNamesRequest).build());
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     *
     * @param lookupPolicyRequest
     * @return A Java Future containing the result of the LookupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.LookupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LookupPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<LookupPolicyResponse> lookupPolicy(LookupPolicyRequest lookupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link LookupPolicyRequest#builder()}
     * </p>
     *
     * @param lookupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link LookupPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the LookupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.LookupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LookupPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<LookupPolicyResponse> lookupPolicy(Consumer<LookupPolicyRequest.Builder> lookupPolicyRequest) {
        return lookupPolicy(LookupPolicyRequest.builder().applyMutation(lookupPolicyRequest).build());
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #lookupPolicy(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher publisher = client.lookupPolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher publisher = client.lookupPolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupPolicy(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest)} operation.</b>
     * </p>
     *
     * @param lookupPolicyRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.LookupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LookupPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default LookupPolicyPublisher lookupPolicyPaginator(LookupPolicyRequest lookupPolicyRequest) {
        return new LookupPolicyPublisher(this, lookupPolicyRequest);
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #lookupPolicy(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher publisher = client.lookupPolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher publisher = client.lookupPolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupPolicy(software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link LookupPolicyRequest#builder()}
     * </p>
     *
     * @param lookupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link LookupPolicyRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>InvalidNextTokenException Indicates that the <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.LookupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/LookupPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default LookupPolicyPublisher lookupPolicyPaginator(Consumer<LookupPolicyRequest.Builder> lookupPolicyRequest) {
        return lookupPolicyPaginator(LookupPolicyRequest.builder().applyMutation(lookupPolicyRequest).build());
    }

    /**
     * <p>
     * Publishes a development schema with a major version and a recommended minor version.
     * </p>
     *
     * @param publishSchemaRequest
     * @return A Java Future containing the result of the PublishSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SchemaAlreadyPublishedException Indicates that a schema is already published.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PublishSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PublishSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishSchemaResponse> publishSchema(PublishSchemaRequest publishSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a development schema with a major version and a recommended minor version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link PublishSchemaRequest#builder()}
     * </p>
     *
     * @param publishSchemaRequest
     *        A {@link Consumer} that will call methods on {@link PublishSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PublishSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SchemaAlreadyPublishedException Indicates that a schema is already published.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PublishSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PublishSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishSchemaResponse> publishSchema(Consumer<PublishSchemaRequest.Builder> publishSchemaRequest) {
        return publishSchema(PublishSchemaRequest.builder().applyMutation(publishSchemaRequest).build());
    }

    /**
     * <p>
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     *
     * @param putSchemaFromJsonRequest
     * @return A Java Future containing the result of the PutSchemaFromJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidSchemaDocException Indicates that the provided <code>SchemaDoc</code> value is not valid.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PutSchemaFromJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PutSchemaFromJson"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSchemaFromJsonResponse> putSchemaFromJson(PutSchemaFromJsonRequest putSchemaFromJsonRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json">JSON
     * Schema Format</a> for more information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSchemaFromJsonRequest.Builder} avoiding the need
     * to create one manually via {@link PutSchemaFromJsonRequest#builder()}
     * </p>
     *
     * @param putSchemaFromJsonRequest
     *        A {@link Consumer} that will call methods on {@link PutSchemaFromJsonRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutSchemaFromJson operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidSchemaDocException Indicates that the provided <code>SchemaDoc</code> value is not valid.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.PutSchemaFromJson
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PutSchemaFromJson"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSchemaFromJsonResponse> putSchemaFromJson(
            Consumer<PutSchemaFromJsonRequest.Builder> putSchemaFromJsonRequest) {
        return putSchemaFromJson(PutSchemaFromJsonRequest.builder().applyMutation(putSchemaFromJsonRequest).build());
    }

    /**
     * <p>
     * Removes the specified facet from the specified object.
     * </p>
     *
     * @param removeFacetFromObjectRequest
     * @return A Java Future containing the result of the RemoveFacetFromObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.RemoveFacetFromObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/RemoveFacetFromObject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFacetFromObjectResponse> removeFacetFromObject(
            RemoveFacetFromObjectRequest removeFacetFromObjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified facet from the specified object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFacetFromObjectRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveFacetFromObjectRequest#builder()}
     * </p>
     *
     * @param removeFacetFromObjectRequest
     *        A {@link Consumer} that will call methods on {@link RemoveFacetFromObjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveFacetFromObject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.RemoveFacetFromObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/RemoveFacetFromObject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFacetFromObjectResponse> removeFacetFromObject(
            Consumer<RemoveFacetFromObjectRequest.Builder> removeFacetFromObjectRequest) {
        return removeFacetFromObject(RemoveFacetFromObjectRequest.builder().applyMutation(removeFacetFromObjectRequest).build());
    }

    /**
     * <p>
     * An API operation for adding tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API operation for adding tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * An API operation for removing tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API operation for removing tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidTaggingRequestException Can occur for multiple reasons such as when you tag a resource that
     *         doesn’t exist or if you specify a higher number of tags for a resource than the allowed limit. Allowed
     *         limit is 50 tags per resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Adds new <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Updates existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deletes existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateFacetRequest
     * @return A Java Future containing the result of the UpdateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFacetResponse> updateFacet(UpdateFacetRequest updateFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Adds new <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Updates existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deletes existing <code>Attributes</code>, <code>Rules</code>, or <code>ObjectTypes</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFacetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFacetRequest#builder()}
     * </p>
     *
     * @param updateFacetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFacetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateFacet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFacetResponse> updateFacet(Consumer<UpdateFacetRequest.Builder> updateFacetRequest) {
        return updateFacet(UpdateFacetRequest.builder().applyMutation(updateFacetRequest).build());
    }

    /**
     * <p>
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s
     * identity, as defined by its <code>IdentityAttributeOrder</code>.
     * </p>
     *
     * @param updateLinkAttributesRequest
     * @return A Java Future containing the result of the UpdateLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLinkAttributesResponse> updateLinkAttributes(
            UpdateLinkAttributesRequest updateLinkAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s
     * identity, as defined by its <code>IdentityAttributeOrder</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLinkAttributesRequest#builder()}
     * </p>
     *
     * @param updateLinkAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLinkAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLinkAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateLinkAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateLinkAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLinkAttributesResponse> updateLinkAttributes(
            Consumer<UpdateLinkAttributesRequest.Builder> updateLinkAttributesRequest) {
        return updateLinkAttributes(UpdateLinkAttributesRequest.builder().applyMutation(updateLinkAttributesRequest).build());
    }

    /**
     * <p>
     * Updates a given object's attributes.
     * </p>
     *
     * @param updateObjectAttributesRequest
     * @return A Java Future containing the result of the UpdateObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateObjectAttributesResponse> updateObjectAttributes(
            UpdateObjectAttributesRequest updateObjectAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a given object's attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateObjectAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateObjectAttributesRequest#builder()}
     * </p>
     *
     * @param updateObjectAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateObjectAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateObjectAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>DirectoryNotEnabledException Operations are only permitted on enabled directories.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>LinkNameAlreadyInUseException Indicates that a link could not be created due to a naming conflict.
     *         Choose a different name and then try again.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateObjectAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateObjectAttributesResponse> updateObjectAttributes(
            Consumer<UpdateObjectAttributesRequest.Builder> updateObjectAttributesRequest) {
        return updateObjectAttributes(UpdateObjectAttributesRequest.builder().applyMutation(updateObjectAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Updates the schema name with a new name. Only development schema names can be updated.
     * </p>
     *
     * @param updateSchemaRequest
     * @return A Java Future containing the result of the UpdateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSchemaResponse> updateSchema(UpdateSchemaRequest updateSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schema name with a new name. Only development schema names can be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSchemaRequest#builder()}
     * </p>
     *
     * @param updateSchemaRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSchemaResponse> updateSchema(Consumer<UpdateSchemaRequest.Builder> updateSchemaRequest) {
        return updateSchema(UpdateSchemaRequest.builder().applyMutation(updateSchemaRequest).build());
    }

    /**
     * <p>
     * Updates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     *
     * @param updateTypedLinkFacetRequest
     * @return A Java Future containing the result of the UpdateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTypedLinkFacetResponse> updateTypedLinkFacet(
            UpdateTypedLinkFacetRequest updateTypedLinkFacetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <a>TypedLinkFacet</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTypedLinkFacetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTypedLinkFacetRequest#builder()}
     * </p>
     *
     * @param updateTypedLinkFacetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTypedLinkFacetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTypedLinkFacet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>FacetValidationException The <a>Facet</a> that you provided was not well formed or could not be
     *         validated with the schema.</li>
     *         <li>InvalidFacetUpdateException An attempt to modify a <a>Facet</a> resulted in an invalid schema
     *         exception.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>FacetNotFoundException The specified <a>Facet</a> could not be found.</li>
     *         <li>InvalidRuleException Occurs when any of the rule parameter keys or values are invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpdateTypedLinkFacet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateTypedLinkFacet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTypedLinkFacetResponse> updateTypedLinkFacet(
            Consumer<UpdateTypedLinkFacetRequest.Builder> updateTypedLinkFacetRequest) {
        return updateTypedLinkFacet(UpdateTypedLinkFacetRequest.builder().applyMutation(updateTypedLinkFacetRequest).build());
    }

    /**
     * <p>
     * Upgrades a single directory in-place using the <code>PublishedSchemaArn</code> with schema updates found in
     * <code>MinorVersion</code>. Backwards-compatible minor version upgrades are instantaneously available for readers
     * on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given
     * directory per call. To upgrade multiple directories from one schema, you would need to call this API on each
     * directory.
     * </p>
     *
     * @param upgradeAppliedSchemaRequest
     * @return A Java Future containing the result of the UpgradeAppliedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradeAppliedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradeAppliedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeAppliedSchemaResponse> upgradeAppliedSchema(
            UpgradeAppliedSchemaRequest upgradeAppliedSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrades a single directory in-place using the <code>PublishedSchemaArn</code> with schema updates found in
     * <code>MinorVersion</code>. Backwards-compatible minor version upgrades are instantaneously available for readers
     * on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given
     * directory per call. To upgrade multiple directories from one schema, you would need to call this API on each
     * directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeAppliedSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link UpgradeAppliedSchemaRequest#builder()}
     * </p>
     *
     * @param upgradeAppliedSchemaRequest
     *        A {@link Consumer} that will call methods on {@link UpgradeAppliedSchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpgradeAppliedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>SchemaAlreadyExistsException Indicates that a schema could not be created due to a naming conflict.
     *         Please select a different name and then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradeAppliedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradeAppliedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeAppliedSchemaResponse> upgradeAppliedSchema(
            Consumer<UpgradeAppliedSchemaRequest.Builder> upgradeAppliedSchemaRequest) {
        return upgradeAppliedSchema(UpgradeAppliedSchemaRequest.builder().applyMutation(upgradeAppliedSchemaRequest).build());
    }

    /**
     * <p>
     * Upgrades a published schema under a new minor version revision using the current contents of
     * <code>DevelopmentSchemaArn</code>.
     * </p>
     *
     * @param upgradePublishedSchemaRequest
     * @return A Java Future containing the result of the UpgradePublishedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradePublishedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradePublishedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradePublishedSchemaResponse> upgradePublishedSchema(
            UpgradePublishedSchemaRequest upgradePublishedSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrades a published schema under a new minor version revision using the current contents of
     * <code>DevelopmentSchemaArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradePublishedSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link UpgradePublishedSchemaRequest#builder()}
     * </p>
     *
     * @param upgradePublishedSchemaRequest
     *        A {@link Consumer} that will call methods on {@link UpgradePublishedSchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpgradePublishedSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException Indicates a problem that must be resolved by Amazon Web Services. This might
     *         be a transient error in which case you can retry your request until it succeeds. Otherwise, go to the <a
     *         href="http://status.aws.amazon.com/">AWS Service Health Dashboard</a> site to see if there are any
     *         operational issues with the service.</li>
     *         <li>InvalidArnException Indicates that the provided ARN value is not valid.</li>
     *         <li>RetryableConflictException Occurs when a conflict with a previous successful write is detected. For
     *         example, if a write operation occurs on an object and then an attempt is made to read the object using
     *         “SERIALIZABLE” consistency, this exception may result. This generally occurs when the previous write did
     *         not have time to propagate to the host serving the current request. A retry (with appropriate backoff
     *         logic) is the recommended response to this exception.</li>
     *         <li>ValidationException Indicates that your request is malformed in some manner. See the exception
     *         message.</li>
     *         <li>IncompatibleSchemaException Indicates a failure occurred while performing a check for backward
     *         compatibility between the specified schema and the schema that is currently applied to the directory.</li>
     *         <li>AccessDeniedException Access denied or directory not found. Either you don't have permissions for
     *         this directory or the directory does not exist. Try calling <a>ListDirectories</a> and check your
     *         permissions.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>InvalidAttachmentException Indicates that an attempt to make an attachment was invalid. For example,
     *         attaching two nodes with a link type that is not applicable to the nodes or attempting to apply a schema
     *         to a directory a second time.</li>
     *         <li>LimitExceededException Indicates that limits are exceeded. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html">Limits</a> for more
     *         information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudDirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudDirectoryAsyncClient.UpgradePublishedSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpgradePublishedSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradePublishedSchemaResponse> upgradePublishedSchema(
            Consumer<UpgradePublishedSchemaRequest.Builder> upgradePublishedSchemaRequest) {
        return upgradePublishedSchema(UpgradePublishedSchemaRequest.builder().applyMutation(upgradePublishedSchemaRequest)
                .build());
    }

    @Override
    default CloudDirectoryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudDirectoryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudDirectoryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudDirectoryAsyncClient}.
     */
    static CloudDirectoryAsyncClientBuilder builder() {
        return new DefaultCloudDirectoryAsyncClientBuilder();
    }
}
