/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClientBuilder;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.clouddirectory.DefaultCloudDirectoryBaseClientBuilder;
import software.amazon.awssdk.services.clouddirectory.DefaultCloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.endpoints.CloudDirectoryEndpointProvider;

@SdkInternalApi
final class DefaultCloudDirectoryClientBuilder
extends DefaultCloudDirectoryBaseClientBuilder<CloudDirectoryClientBuilder, CloudDirectoryClient>
implements CloudDirectoryClientBuilder {
    DefaultCloudDirectoryClientBuilder() {
    }

    @Override
    public DefaultCloudDirectoryClientBuilder endpointProvider(CloudDirectoryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudDirectoryClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudDirectoryClientBuilder.validateClientOptions(clientConfiguration);
        CloudDirectoryServiceClientConfiguration serviceClientConfiguration = CloudDirectoryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCloudDirectoryClient(serviceClientConfiguration, clientConfiguration);
    }
}

